/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.text;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.validate.IInputTextValidator;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.text.abstractions.ITextDisplay;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.util.Validator;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TextEditPanel
extends JPanel
implements DataEditor,
ITextDisplay {
    private final String className_;
    private final JLabel promptLabel_ = new JLabel("");
    private final JTextField mainText_ = new JTextField("", 15);
    private IInputTextValidator inputValidator;
    private Identifiable idf_;
    private final SwingThemeCtrl themeCtrl_;
    private String title_;

    public TextEditPanel(String className, String prompt, String currentText) {
        this.className_ = className;
        this.promptLabel_.setText(prompt);
        this.setTitle(this.className_);
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setText(currentText);
        this.initComponents();
        this.buildPanel();
        this.setNames();
    }

    public void setInputValidator(IInputTextValidator inputValidator) {
        this.inputValidator = inputValidator;
    }

    private void buildPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.promptLabel_, this.mainText_, gbc, this, row++);
        GuiHelper.addEmptyBorder(this);
        this.setCosmetics();
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.promptLabel_);
        this.themeCtrl_.process(this.mainText_);
        if (Validator.isStringValid(this.mainText_.getText())) {
            this.mainText_.selectAll();
        }
    }

    private void setNames() {
        this.promptLabel_.setName("promptLabel");
        this.mainText_.setName("mainText");
    }

    @Override
    public String getText() {
        return this.mainText_.getText();
    }

    @Override
    public ITestResult validateData() {
        if (this.inputValidator != null) {
            String text = this.getText();
            return this.inputValidator.isInputValid(text);
        }
        return new DataEntryResult();
    }

    @Override
    public Collector getCollector() {
        return null;
    }

    @Override
    public Identifiable getDataObject() {
        this.validateData();
        return this.idf_;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 325, 170);
    }

    private void initComponents() {
        this.setLayout(null);
    }

    public final void setTitle(String title) {
        this.title_ = title;
    }

    @Override
    public final void setText(String text) {
        this.mainText_.setText(text);
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    @Override
    public void setSyncOnEdit(boolean sync) {
    }
}

