/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.text;

import com.harrand.coregui.Icons;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.text.LogPane;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class LogPanel
extends JPanel {
    private LogPane logPane_ = new LogPane();
    private JLabel lblTitle_ = new JLabel();
    private boolean showClearBtn_ = true;
    private JButton btnClear_ = new JButton(ResMgr.getRes("edit.clear"), Icons.ERASE);

    public LogPanel(String labelText, boolean showClearBtn) {
        this.lblTitle_.setText(labelText);
        this.showClearBtn_ = showClearBtn;
        this.layoutPanel();
        this.addListeners();
        this.setCosmetics();
    }

    public void addClearListener(ActionListener lis) {
        this.btnClear_.addActionListener(lis);
    }

    public LogPane getLogPane() {
        return this.logPane_;
    }

    public void clear() {
        this.logPane_.clear();
    }

    public void logPlain(String msg) {
        this.logPane_.logPlain(msg);
    }

    public void logError(String msg) {
        this.logPane_.logError(msg);
    }

    private void addListeners() {
        this.btnClear_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogPanel.this.logPane_.clear();
            }
        });
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.lblTitle_, "North");
        this.add((Component)new JScrollPane(this.logPane_), "Center");
        if (this.showClearBtn_) {
            this.add((Component)this.getBtnPanel(), "South");
        }
    }

    private JPanel getBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(Box.createGlue());
        panel.add(this.btnClear_);
        GuiHelper.addTopBottomBorder(panel);
        return panel;
    }

    private void setCosmetics() {
        this.btnClear_.setToolTipText(ResMgr.getRes("log.clear.tooltip"));
    }
}

