/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.text;

import com.harrand.coreclasses.display.Colors;
import com.harrand.util.LogUtil;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class LogPane
extends JTextPane {
    private Style errorStyle_;
    private Style plainStyle_;
    private StyledDocument doc_ = (StyledDocument)this.getDocument();
    private static final String PLAIN_STYLE_NM = "plain";
    private static final String ERROR_STYLE_NM = "error";

    public LogPane() {
        this.setEditable(false);
        this.createStyles();
    }

    public void clear() {
        this.setText("");
    }

    public void logPlain(String text) {
        this.appendText(text, this.plainStyle_);
    }

    public void logError(String text) {
        this.appendText(text, this.errorStyle_);
    }

    private void appendText(String text, Style style) {
        try {
            this.doc_.insertString(this.doc_.getLength(), text + "\n", style);
            this.scrollDown();
        }
        catch (BadLocationException ex) {
            LogUtil.logErr("LogPane.appendText().err: " + ex.getMessage());
        }
    }

    private void createStyles() {
        this.plainStyle_ = this.doc_.addStyle(PLAIN_STYLE_NM, null);
        this.errorStyle_ = this.doc_.addStyle(ERROR_STYLE_NM, null);
        StyleConstants.setForeground(this.errorStyle_, Colors.getMaroon());
    }

    public void scrollDown() {
        try {
            final LogPane thisPane = this;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    thisPane.setCaretPosition(LogPane.this.doc_.getLength());
                }
            });
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }
}

