/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.text;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.text.element.StringTriplet;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class LabelFieldArrayPanel
extends JPanel {
    private List stringTriplets_;
    private SwingThemeCtrl themeCtrl_;
    private Map textFields_ = new TreeMap();

    public LabelFieldArrayPanel(List stringTriplets) {
        this.stringTriplets_ = stringTriplets;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.buildPanel();
    }

    public void setText(String key, String newText) {
        JTextField textfield = this.getTextField(key);
        if (textfield != null) {
            textfield.setText(newText);
        }
    }

    public String getText(String key) {
        JTextField textfield = this.getTextField(key);
        if (textfield != null) {
            return textfield.getText();
        }
        return "";
    }

    private JTextField getTextField(String key) {
        if (this.textFields_.containsKey(key)) {
            return (JTextField)this.textFields_.get(key);
        }
        StrHelper.throwProgExcept("LabelFieldArray does not contain: " + key);
        return null;
    }

    private void buildPanel() {
        this.layoutControls();
        this.setCosmetics();
    }

    private void layoutControls() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        int row = 0;
        for (StringTriplet triplet : this.stringTriplets_) {
            JLabel lbl = new JLabel(triplet.getPrompt());
            JTextField textField = new JTextField(triplet.getDefaultValue());
            this.themeCtrl_.process(lbl);
            this.themeCtrl_.process(textField);
            textField.setName("textField" + triplet.getKey());
            this.textFields_.put(triplet.getKey(), textField);
            GuiHelper.addGridbagPair(lbl, textField, gbc, this, row++);
        }
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
    }
}

