/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.text;

import java.awt.Toolkit;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public final class IntegerTextField
extends JTextField {
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private NumberFormat integerFormatter = NumberFormat.getNumberInstance(Locale.US);

    public IntegerTextField(int value, int columns) {
        super(columns);
        this.integerFormatter.setParseIntegerOnly(true);
        this.setValue(value);
    }

    public int getValue() {
        int retVal = 0;
        try {
            retVal = this.integerFormatter.parse(this.getText()).intValue();
        }
        catch (ParseException e) {
            this.toolkit.beep();
        }
        return retVal;
    }

    public void setValue(int value) {
        this.setText(this.integerFormatter.format(value));
    }

    @Override
    protected Document createDefaultModel() {
        return new WholeNumberDocument();
    }

    protected class WholeNumberDocument
    extends PlainDocument {
        protected WholeNumberDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                IntegerTextField.this.toolkit.beep();
            }
            super.insertString(offs, new String(result, 0, j), a);
        }
    }
}

