/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IErgonomicPanel;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.interfaces.implementation.BasicCollector;
import com.harrand.coreclasses.list.ISelectedProvider;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.rename.IRenameMgrSource;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.idf.RenameIdf;
import com.harrand.coregui.command.idf.UpdateInCollector;
import com.harrand.coregui.command.prompt.PromptCollectionUpdate;
import com.harrand.coregui.dataEntry.IEditorActionFactory;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.table.ColorableJTable;
import com.harrand.coregui.table.ComboBoxTableCellEditor;
import com.harrand.coregui.table.ComboBoxTableCellRenderer;
import com.harrand.coregui.table.TableModelBasic;
import com.harrand.util.LogUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public final class TablePanel
extends JPanel
implements IObserver,
ISelectedProvider,
ISized,
IErgonomicPanel {
    private ColorableJTable table_;
    private final ITableDriver driver_;
    private final TableModelBasic tableModel_ = new TableModelBasic();
    private final JScrollPane scroll_;
    private final SwingThemeCtrl themeCtrl_;
    private CommandChain cmdChain_ = null;
    private IEditorActionFactory editorActionFactory_;

    public TablePanel(ITableDriver driver) {
        this.driver_ = driver;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.initTable();
        this.setLayout(new BorderLayout());
        this.scroll_ = new JScrollPane(this.table_);
        this.add((Component)this.scroll_, "Center");
        this.cmdChain_ = CommandChainMgr.getInstance().getCommandChain();
        this.addListeners();
        this.setObserver();
        this.setCosmetics();
        this.setNames();
        this.refresh();
    }

    public void selectFirstRow() {
        this.table_.getSelectionModel().setSelectionInterval(0, 0);
        this.table_.requestFocus();
    }

    private void initTable() {
        this.updateTableModel();
        this.table_ = new ColorableJTable(this.tableModel_);
        this.setNames();
    }

    public void setObserver() {
        if (this.getCollector() instanceof IObservable) {
            ((IObservable)((Object)this.getCollector())).addObserver(this);
        }
    }

    public ITableDriver getTableDriver() {
        return this.driver_;
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.scroll_);
        this.themeCtrl_.process(this.table_);
        this.table_.setAutoResizeMode(0);
        this.setRowHeight();
        int rowHeight = this.table_.getRowHeight();
    }

    private void setNames() {
        this.setName(this.driver_.getIdfClassName() + "TablePanel");
        this.table_.setName("table");
    }

    public void setEditorActionFactory(IEditorActionFactory actionFactory) {
        this.editorActionFactory_ = actionFactory;
    }

    private void setRowHeight() {
        boolean hasCombo = false;
        Enumeration<TableColumn> enm = this.table_.getColumnModel().getColumns();
        while (enm.hasMoreElements() && !hasCombo) {
            TableColumn column = enm.nextElement();
            if (!(column.getCellEditor() instanceof ComboBoxTableCellEditor) && !(column.getCellRenderer() instanceof ComboBoxTableCellRenderer)) continue;
            hasCombo = true;
        }
        if (hasCombo) {
            this.table_.setRowHeight(17);
        }
    }

    private void addListeners() {
        this.tableModel_.addTableModelListener(this.getTableModelListener());
        this.table_.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row = TablePanel.this.table_.rowAtPoint(e.getPoint());
                if (e.getClickCount() == 2) {
                    TablePanel.this.showDataEditor(row);
                }
                if (e.getButton() == 2) {
                    TablePanel.this.showDataEditor(row);
                }
                if (e.getButton() == 3) {
                    TablePanel.this.showDataEditor(row);
                }
            }
        });
    }

    private TableModelListener getTableModelListener() {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int row = e.getFirstRow();
                int column = e.getColumn();
                if (row >= 0 && column >= 0) {
                    TablePanel.this.updateData(TablePanel.this.getDataMap(row));
                }
            }
        };
    }

    public void updateData(Map data) {
        Identifiable oldIdf = this.getIdentifiable(data);
        Identifiable newIdf = null;
        try {
            newIdf = this.driver_.buildObject(data);
            BasicCollector.verifyNoDups(this.getCollector(), oldIdf, newIdf);
        }
        catch (Exception e) {
            GuiMessageHelper.showInputErrMsg(null, "Invalid Entry", e.getMessage());
            this.refresh();
            return;
        }
        GuiHelper.setBusyCursor(this);
        Command cmd = null;
        if (this.cmdChain_ == null) {
            LogUtil.logErr("TablePanel.cmdChain NULL");
        }
        if (!oldIdf.equals(newIdf)) {
            boolean renameOk;
            String oldName = (String)data.get("ID");
            String newName = newIdf.getName();
            String clsNm = newIdf.getMapName();
            boolean bl = renameOk = clsNm.equalsIgnoreCase("Table") || clsNm.equalsIgnoreCase("Column");
            if (!oldName.equals(newName) && renameOk) {
                cmd = new RenameIdf(this.getCollector(), oldIdf, oldName, newName, this.cmdChain_);
                if (this.driver_ instanceof IRenameMgrSource) {
                    IRenameMgrSource mgrSource = (IRenameMgrSource)((Object)this.driver_);
                    ((RenameIdf)cmd).setRenameMgr(mgrSource.getRenameMgr());
                }
            } else {
                cmd = new UpdateInCollector(this.getCollector(), oldIdf, newIdf);
                cmd.setCommandChain(this.cmdChain_);
            }
        }
        if (cmd != null) {
            cmd.actionPerformed(new ActionEvent(this, 0, ""));
        }
        GuiHelper.setDefaultCursor(this);
        this.refresh();
    }

    private Identifiable getIdentifiable(Map data) {
        String id = (String)data.get("ID");
        return this.getCollector().get(this.getIdfClassName(), id);
    }

    private Map getDataMap(int row) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (int i = 0; i < this.tableModel_.getColumnCount(); ++i) {
            String key = this.tableModel_.getColumnName(i);
            Object value = this.tableModel_.getValueAt(row, i);
            data.put(key, value);
        }
        return data;
    }

    private void showDataEditor(int row) {
        Collector collector = this.driver_.getCollector();
        Identifiable idf = this.getIdentifiable(this.getDataMap(row));
        DataEditor editor = this.driver_.getDataEditor(idf);
        ActionListener editorAction = null;
        if (this.editorActionFactory_ != null) {
            editorAction = this.editorActionFactory_.getUpdateEditorAction(this.getCollector(), idf);
        }
        if (editorAction != null) {
            editorAction.actionPerformed(null);
        } else if (collector != null && editor != null) {
            PromptCollectionUpdate cmd = new PromptCollectionUpdate(collector, editor.getDataObject(), editor);
            if (this.driver_ instanceof IRenameMgrSource) {
                IRenameMgrSource mgrSource = (IRenameMgrSource)((Object)this.driver_);
                cmd.setRenameMgr(mgrSource.getRenameMgr());
            }
            cmd.actionPerformed(null);
        }
    }

    public void refresh() {
        this.updateTableModel();
    }

    private void updateTableModel() {
        this.tableModel_.setDataVector(this.driver_.getDataMatrix(), this.driver_.getHeaders());
        if (this.table_ != null) {
            this.setHiddenColumns();
            this.setRenderers();
            this.setEditors();
            this.setUneditableColumns();
            this.setBackColors();
            this.table_.setAutoResizeMode(0);
            GuiHelper.optimizeTableColumnWidths(this.table_, 600);
        }
    }

    private void setBackColors() {
        Color unEditColor = this.themeCtrl_.getUneditColumnBackground();
        int rowCount = this.table_.getRowCount();
        int colCount = this.table_.getColumnCount();
        Color[][] colors = new Color[rowCount][colCount];
        ArrayList<Object> headersList = new ArrayList<Object>(Arrays.asList(this.driver_.getHeaders()));
        int backColorIdx = headersList.indexOf("BkColor");
        if (backColorIdx >= 0) {
            Object[][] data = this.driver_.getDataMatrix();
            for (int row = 0; row < rowCount; ++row) {
                Color color = (Color)data[row][backColorIdx];
                for (int col = 0; col < colCount; ++col) {
                    colors[row][col] = color;
                }
            }
        }
        List unEditableColumnNames = this.driver_.getUneditableColumns();
        unEditableColumnNames.removeAll(this.driver_.getHiddenColumns());
        TableColumnModel columnModel = this.table_.getColumnModel();
        for (int c = 0; c < columnModel.getColumnCount(); ++c) {
            TableColumn column = columnModel.getColumn(c);
            String headerStr = column.getHeaderValue().toString();
            if (!unEditableColumnNames.contains(headerStr)) continue;
            this.setColumnColor(colors, rowCount, c, unEditColor);
        }
        this.table_.setColorMatrix(colors);
    }

    private void setColumnColor(Color[][] colorMatrix, int rowCount, int column, Color color) {
        for (int row = 0; row < rowCount; ++row) {
            Color currentColor = colorMatrix[row][column];
            if (currentColor != null && !currentColor.equals(Color.WHITE)) continue;
            colorMatrix[row][column] = color;
        }
    }

    private void setHiddenColumns() {
        TableColumn column;
        TableColumnModel tcm = this.table_.getColumnModel();
        for (String str : this.driver_.getHiddenColumns()) {
            column = this.table_.getColumn(str);
            tcm.removeColumn(column);
        }
        try {
            column = this.table_.getColumn("BkColor");
            if (column != null) {
                tcm.removeColumn(column);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setUneditableColumns() {
        Object[] headers = this.driver_.getHeaders();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        Iterator it = this.driver_.getUneditableColumns().iterator();
        while (it.hasNext()) {
            int index = -1;
            String name = (String)it.next();
            for (int i = 0; i < headers.length; ++i) {
                if (!headers[i].toString().equals(name)) continue;
                index = i;
            }
            if (index < 0) continue;
            indexes.add(new Integer(index));
        }
        this.tableModel_.setNonEditableColumnIndexes(indexes);
    }

    private void setRenderers() {
        Map map = this.driver_.getCustomCellRenderers();
        for (String columnName : map.keySet()) {
            this.table_.getColumn(columnName).setCellRenderer((TableCellRenderer)map.get(columnName));
        }
    }

    private void setEditors() {
        Map map = this.driver_.getCustomCellEditors();
        for (String columnName : map.keySet()) {
            this.table_.getColumn(columnName).setCellEditor((TableCellEditor)map.get(columnName));
        }
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasClassName(this.getIdfClassName()) || chain.hasClassName(this.getCollector().getMapName())) {
            this.refresh();
        }
    }

    @Override
    public Collector getCollector() {
        return this.driver_.getCollector();
    }

    @Override
    public String getDisplayName() {
        return this.driver_.getDisplayName();
    }

    @Override
    public String getDisplayPlural() {
        return this.driver_.getDisplayPlural();
    }

    @Override
    public String getIdfClassName() {
        return this.driver_.getIdfClassName();
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        return this.driver_.getDataEditor(currentIdf);
    }

    @Override
    public List getSelectedIds() {
        int nameIndex = -1;
        for (int i = 0; i < this.tableModel_.getColumnCount(); ++i) {
            String colNm = this.tableModel_.getColumnName(i);
            if (colNm.equalsIgnoreCase("ID")) {
                nameIndex = i;
            }
            if (!colNm.equalsIgnoreCase("Str Id")) continue;
            nameIndex = i;
        }
        ArrayList<String> toRemove = new ArrayList<String>();
        if (nameIndex >= 0) {
            int[] selectedRows = this.table_.getSelectedRows();
            for (int i = 0; i < selectedRows.length; ++i) {
                toRemove.add((String)this.tableModel_.getValueAt(selectedRows[i], nameIndex));
            }
        } else {
            StrHelper.throwProgrammingException("TablePanel could NOT find column name to match for HD_ID.");
        }
        return toRemove;
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.getClazzIcon(this.getIdfClassName());
    }

    @Override
    public String getTitle() {
        return this.getDisplayPlural();
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public JButton getDefaultButton() {
        return null;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 350, 270);
    }
}

