/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.table;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.db.DbDataResult;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.option.IOptionMgrSvr;
import com.harrand.coreclasses.text.QuickTimeFormat;
import com.harrand.coregui.Icons;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.label.StatusLabel;
import com.harrand.coregui.panel.StatusPanel;
import com.harrand.coregui.table.TableModelBasic;
import com.harrand.util.FileHelper;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class ResultsGridPanel
extends JPanel
implements IObserver,
ISized {
    private JToggleButton btnAsText_;
    private JToggleButton btnAsGrid_;
    private JToggleButton btnMsg_ = new JToggleButton("...");
    private JTable table_;
    private DbDataResult dataResult = null;
    private JScrollPane scrTable_;
    private JScrollPane scrText_;
    private JScrollPane scrMsg_;
    private DefaultTableModel blankTableModel_;
    private JTextArea txtData_ = new JTextArea("");
    private JTextArea txtMsg_ = new JTextArea("");
    private JTextField txtCommand_ = new JTextField();
    private JPanel panCards_ = new JPanel(new CardLayout());
    private List statusPanels_;
    private StatusLabel rowStatusLabel_;
    private StatusLabel elapsedStatusLabel_;
    private IOptionMgrSvr mgrSvr_ = null;
    private IOptionMgr resultOptionMgr_ = null;
    private ImageIcon icon_;
    private Color msgTextDefaultColor_ = Color.BLACK;
    private Color msgTextErrorColor_ = Colors.getFireBrick();
    private boolean gridDefault_;
    private boolean nullAsBlank_;
    private int msgMaxLength_;
    private int gridColWidthMax_;
    private int textColWidthMax_;
    private int[] colPixels_;
    private int[] colChars_;
    private static final int TABLE_COLUMN_PAD_PX = 20;
    private static final int CHAR_COLUMN_PAD = 4;
    private static final String GRID_KEY = "TableKey";
    private static final String TEXT_KEY = "TextKey";
    private static final String MSG_KEY = "MsgKey";
    private static final String NULL_STR = "NULL";

    public ResultsGridPanel(IOptionMgrSvr mgrSvr, DbDataResult dataResult) {
        this.setOptionMgrSvr(mgrSvr);
        this.updateOptions();
        this.buildPanel();
        this.dataResult = dataResult;
        this.refresh();
    }

    public ImageIcon getIcon() {
        return this.icon_;
    }

    private void buildPanel() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
        this.addObservers();
    }

    public void setOptionMgrSvr(IOptionMgrSvr mgrSvr) {
        if (mgrSvr == null) {
            System.out.println("TableMsgPanel.mgrSvr is null");
        }
        this.mgrSvr_ = mgrSvr;
        this.resultOptionMgr_ = this.mgrSvr_.getOptionMgr("result.option.mgr");
        this.updateOptions();
        this.addObservers();
    }

    public IOptionMgrSvr getOptionMgrSvr() {
        return this.mgrSvr_;
    }

    private void buildControls() {
        this.btnAsText_ = new JToggleButton(Icons.TEXT);
        this.btnAsGrid_ = new JToggleButton(Icons.TABLE);
        this.blankTableModel_ = new DefaultTableModel(new String[]{" "}, 0);
        this.table_ = new JTable(this.blankTableModel_);
        this.scrTable_ = new JScrollPane(this.table_);
        this.scrText_ = new JScrollPane(this.txtData_);
        this.scrMsg_ = new JScrollPane(this.txtMsg_);
        this.rowStatusLabel_ = new StatusLabel(50, this.getRowCountText(), null);
        this.elapsedStatusLabel_ = new StatusLabel(50, this.getElapseTimeText(-1L), Icons.CLOCK);
        this.statusPanels_ = new ArrayList();
        this.statusPanels_.add(this.rowStatusLabel_);
        this.statusPanels_.add(this.elapsedStatusLabel_);
    }

    private void checkErrors() {
        this.icon_ = Icons.EXECUTE;
        if (!this.dataResult.getPassed()) {
            this.txtData_.setText(this.dataResult.getDetail());
            this.showDataAs(MSG_KEY);
            this.btnMsg_.setSelected(true);
            this.icon_ = Icons.CAUTION;
        } else {
            this.icon_ = Icons.CHECK_SM;
        }
        if (this.dataResult.getHadNullResultSet()) {
            this.showDataAs(MSG_KEY);
            this.btnMsg_.setSelected(true);
        }
    }

    private void layoutComponents() {
        JPanel panData = new JPanel(new BorderLayout());
        JPanel panGridData = new JPanel(new BorderLayout());
        JPanel panTextData = new JPanel(new BorderLayout());
        JPanel panMessage = new JPanel(new BorderLayout());
        StatusPanel statusPanel = new StatusPanel(this.statusPanels_, false);
        ButtonGroup group = new ButtonGroup();
        group.add(this.btnAsGrid_);
        group.add(this.btnAsText_);
        group.add(this.btnMsg_);
        panGridData.add((Component)this.scrTable_, "Center");
        panTextData.add((Component)this.scrText_, "Center");
        panMessage.add((Component)this.scrMsg_, "Center");
        this.panCards_.add((Component)panGridData, GRID_KEY);
        this.panCards_.add((Component)panTextData, TEXT_KEY);
        this.panCards_.add((Component)panMessage, MSG_KEY);
        panData.add((Component)this.panCards_, "Center");
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)this.getNorthPanel(), "North");
        this.add((Component)panData, "Center");
        this.add((Component)statusPanel, "South");
    }

    private JPanel getNorthPanel_OLD() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.txtCommand_);
        panel.add(Box.createHorizontalStrut(15));
        panel.add(this.getButtonPanel());
        GuiHelper.addSmallBorder(panel);
        return panel;
    }

    private JPanel getNorthPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.buildGridBagConstraints(gbc, 0, row, 1, 1, 90.0, 0.0);
        gbc.fill = 2;
        gbc.anchor = 17;
        panel.add((Component)this.txtCommand_, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row, 1, 1, 10.0, 0.0);
        gbc.fill = 2;
        panel.add((Component)this.getButtonPanel(), gbc);
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(this.btnMsg_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.btnAsGrid_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.btnAsText_);
        return panel;
    }

    private void refreshCmdText() {
        this.txtCommand_.setText(this.dataResult.getCmdText());
        this.txtCommand_.setCaretPosition(0);
    }

    private void refreshElapsed() {
        this.elapsedStatusLabel_.setText(this.getElapseTimeText(this.dataResult.getElapsedMilliSec()));
    }

    private void setNames() {
        this.btnAsGrid_.setName("btnAsGrid");
        this.btnAsText_.setName("btnAsText");
        this.table_.setName("table");
        this.txtData_.setName("dataTextBox");
        this.rowStatusLabel_.setName("rowStatusLabel");
        this.setName("tableMsgPanel");
    }

    private void setCosmetics() {
        this.btnAsText_.setMaximumSize(this.btnAsGrid_.getMinimumSize());
        this.btnMsg_.setMaximumSize(this.btnAsGrid_.getMinimumSize());
        this.btnAsText_.setToolTipText(FileHelper.getRes("show.data.as.text.tooltip"));
        this.btnAsGrid_.setToolTipText(FileHelper.getRes("show.data.in.grid.tooltip"));
        this.btnMsg_.setToolTipText("DB Server Messages");
        Font boldFont = this.btnMsg_.getFont();
        Font newFont = new Font(boldFont.getName(), 0, boldFont.getSize());
        this.btnMsg_.setFont(newFont);
        this.txtCommand_.setEditable(false);
        this.txtCommand_.setBackground(Colors.getGrayUltraLight());
        this.table_.setRowSelectionAllowed(true);
        this.table_.setColumnSelectionAllowed(true);
        this.txtMsg_.setEditable(false);
        Font monoFont = new Font("monospaced", 0, 11);
        this.txtData_.setFont(monoFont);
        this.txtData_.setBackground(Color.white);
        this.txtData_.setEditable(false);
        this.txtMsg_.setFont(monoFont);
        this.table_.setAutoResizeMode(0);
        this.table_.setOpaque(true);
        this.table_.setBackground(Color.WHITE);
        this.scrTable_.setOpaque(true);
        this.scrTable_.setBackground(Color.WHITE);
    }

    private void addListeners() {
        this.btnAsGrid_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsGridPanel.this.showDataAs(ResultsGridPanel.GRID_KEY);
            }
        });
        this.btnAsText_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsGridPanel.this.showDataAs(ResultsGridPanel.TEXT_KEY);
            }
        });
        this.btnMsg_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultsGridPanel.this.showDataAs(ResultsGridPanel.MSG_KEY);
            }
        });
    }

    private void addObservers() {
        if (this.resultOptionMgr_ instanceof IObservable) {
            ((IObservable)((Object)this.resultOptionMgr_)).addObserver(this);
        }
    }

    private void updateOptions() {
        this.gridDefault_ = this.resultOptionMgr_.getBoolValue("results.grid.default");
        this.nullAsBlank_ = this.resultOptionMgr_.getBoolValue("results.null.as.blank");
        this.msgMaxLength_ = this.resultOptionMgr_.getIntValue("results.msg.max.length");
        this.gridColWidthMax_ = this.resultOptionMgr_.getIntValue("results.grid.col.max.width");
        this.textColWidthMax_ = this.resultOptionMgr_.getIntValue("results.text.col.max.width");
    }

    private void showDataAs(String key) {
        CardLayout cl = (CardLayout)this.panCards_.getLayout();
        cl.show(this.panCards_, key);
    }

    public void refresh() {
        this.clear();
        this.refreshData();
        this.refreshMsg();
        this.refreshCmdText();
        this.refreshElapsed();
        this.refreshStatus();
        this.checkErrors();
        this.invalidate();
        this.revalidate();
    }

    private void refreshData() {
        Object[][] data = this.dataResult.getData();
        this.calcColumnWidths(this.dataResult.getData());
        TableModelBasic tableModel = GuiHelper.getTableModel(data, this.nullAsBlank_);
        tableModel.setEditable(false);
        this.table_.setModel(tableModel);
        this.setTableColumnWidths();
        this.txtData_.setText(this.buildText(data));
        this.txtData_.setCaretPosition(0);
        try {
            if (this.gridDefault_) {
                GuiHelper.pushButton(this.btnAsGrid_);
                this.btnAsGrid_.setSelected(true);
            } else {
                GuiHelper.pushButton(this.btnAsText_);
                this.btnAsText_.setSelected(true);
            }
        }
        catch (Exception e) {
            GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
        }
    }

    private void refreshMsg() {
        if (!this.dataResult.getPassed()) {
            this.txtMsg_.setForeground(this.msgTextErrorColor_);
        } else {
            this.txtMsg_.setForeground(this.msgTextDefaultColor_);
        }
        String msg = this.dataResult.getDetail();
        this.txtMsg_.setText(msg);
        this.txtMsg_.setCaretPosition(0);
    }

    private void refreshStatus() {
        this.rowStatusLabel_.setText(this.getRowCountText());
        this.elapsedStatusLabel_.setText(this.getElapseTimeText(this.dataResult.getElapsedMilliSec()));
    }

    public void clear() {
        this.txtData_.setText("");
        this.table_.setModel(this.blankTableModel_);
        this.rowStatusLabel_.setText(this.getRowCountText());
    }

    private void calcColumnWidths(Object[][] data) {
        int rowCount = data.length;
        int colCount = data[0].length;
        this.colPixels_ = new int[colCount];
        this.colChars_ = new int[colCount];
        Font font = this.txtData_.getFont();
        for (int col = 0; col < colCount; ++col) {
            for (int row = 0; row < rowCount; ++row) {
                Object obj = data[row][col];
                if (obj == null) continue;
                String str = data[row][col].toString();
                int currentPixels = GuiHelper.getSwingStringLength(str, font) + 20;
                this.colPixels_[col] = Math.max(this.colPixels_[col], currentPixels);
                this.colChars_[col] = Math.max(this.colChars_[col], str.length());
            }
            this.colPixels_[col] = Math.min(this.colPixels_[col], this.gridColWidthMax_);
            this.colChars_[col] = Math.min(this.colChars_[col], this.textColWidthMax_);
        }
    }

    private void setTableColumnWidths() {
        for (int col = 0; col < this.colPixels_.length; ++col) {
            TableColumn tableColumn = this.table_.getColumnModel().getColumn(col);
            tableColumn.setPreferredWidth(this.colPixels_[col]);
        }
    }

    private String buildText(Object[][] data) {
        StringBuffer sb = new StringBuffer(500);
        String nullStr = this.nullAsBlank_ ? "" : NULL_STR;
        int colCount = data[0].length;
        int rowCount = data.length;
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < colCount; ++col) {
                String str;
                Object obj = data[row][col];
                if (obj == null || obj.toString().equals(NULL_STR)) {
                    obj = nullStr;
                }
                if ((str = obj.toString()).length() > this.textColWidthMax_) {
                    str = StrHelper.getTruncated(str, this.textColWidthMax_);
                }
                sb.append(str);
                int padChars = this.colChars_[col] + 4 - str.length();
                for (int i = 0; i < padChars; ++i) {
                    sb.append(" ");
                }
            }
            sb.append("\n");
            if (row != 0) continue;
            sb.append(this.getSeperator()).append("\n");
        }
        return sb.toString();
    }

    private String getRowCountText() {
        String prefix = FileHelper.getResource("row.label.plural");
        return prefix + ": " + this.table_.getRowCount();
    }

    private String getElapseTimeText(long milliSec) {
        String str = "";
        if (milliSec >= 0L) {
            str = QuickTimeFormat.msToSecs(milliSec);
        }
        return str;
    }

    private String getSeperator() {
        int totalChars = 0;
        for (int col = 0; col < this.colChars_.length; ++col) {
            totalChars += this.colChars_[col] + 4;
        }
        StringBuffer sb = new StringBuffer();
        while (sb.length() < totalChars) {
            sb.append("-");
        }
        return sb.toString();
    }

    @Override
    public void update(UpdateChain chain) {
        this.updateOptions();
        this.refresh();
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(200, 200, 500, 350);
    }
}

