/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.table;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.file.FilePath;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.table.abstraction.ITableDriver;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class FilePathTableDriver
implements ITableDriver {
    private Collector collector_;
    private String className_;

    public FilePathTableDriver(Collector user) {
        this.collector_ = user;
        this.className_ = FilePath.clazz();
    }

    @Override
    public Identifiable buildObject(Map data) throws Exception {
        FilePath newFilePath = null;
        newFilePath = new FilePath((String)data.get("ID"), (String)data.get("Path"));
        return newFilePath;
    }

    @Override
    public String getIdfClassName() {
        return this.className_;
    }

    @Override
    public Collector getCollector() {
        return this.collector_;
    }

    @Override
    public Map getCustomCellEditors() {
        return new HashMap();
    }

    @Override
    public Map getCustomCellRenderers() {
        return new HashMap();
    }

    @Override
    public int getViewPortRows() {
        return 6;
    }

    @Override
    public DataEditor getDataEditor(Identifiable currentIdf) {
        return null;
    }

    @Override
    public Object[][] getDataMatrix() {
        Object[][] matrix = new Object[this.collector_.size(this.className_)][this.getHeaders().length];
        int row = 0;
        for (FilePath filePath : this.collector_.values(this.className_)) {
            int col = 0;
            matrix[row][col++] = filePath.getPathDesc();
            matrix[row][col++] = filePath.getPath();
            matrix[row][col++] = filePath.getName();
            ++row;
        }
        return matrix;
    }

    @Override
    public Object[] getHeaders() {
        Object[] headers = new String[]{"Name", "Path", "ID"};
        return headers;
    }

    @Override
    public String getDisplayName() {
        return this.collector_.getDisplayName(this.className_);
    }

    @Override
    public String getDisplayPlural() {
        return this.collector_.getDisplayPlural(this.className_);
    }

    @Override
    public List getHiddenColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("ID");
        return list;
    }

    @Override
    public List getUneditableColumns() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Name");
        list.add("ID");
        return list;
    }
}

