/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public final class ColorableJTable
extends JTable {
    private Color[][] colorMatrix_ = null;

    public ColorableJTable(TableModel dm) {
        super(dm);
    }

    public void setColorMatrix(Color[][] colorMatrix) {
        this.colorMatrix_ = colorMatrix;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int rowIndex, int vColIndex) {
        Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
        if (this.colorMatrix_ != null && !this.isCellSelected(rowIndex, vColIndex) && this.inBounds(rowIndex, vColIndex)) {
            Color color = this.colorMatrix_[rowIndex][vColIndex];
            c.setBackground(color);
        }
        return c;
    }

    private boolean inBounds(int r, int c) {
        boolean rowOk = r < this.colorMatrix_.length;
        boolean colOk = c < this.colorMatrix_[0].length;
        return rowOk && colOk;
    }
}

