/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.security;

import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.util.ResMgr;
import com.harrand.util.SysUtil;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class CodeBtnPanel
extends JPanel {
    private JButton btnUpdate_ = new JButton(ResMgr.getRes("license.update.label"));
    private JButton btnPurchase_ = new JButton("Purchase License");
    private JButton btnClose_ = GuiHelper.getCloseBtn();
    private JLabel lblOpening_ = new JLabel("");
    private RootPaneContainer parentContainer_;
    private boolean useLargeBorder_;

    public CodeBtnPanel(boolean useLargeBorder) {
        this.useLargeBorder_ = useLargeBorder;
        this.setupGui();
    }

    public void setParentContainer(RootPaneContainer parentContainer) {
        this.parentContainer_ = parentContainer;
    }

    public void setUpdateBtnListener(ActionListener lis) {
        this.btnUpdate_.addActionListener(lis);
    }

    private void setupGui() {
        this.layoutPanel();
        this.addListeners();
        this.setCosmetics();
    }

    private void addListeners() {
        this.btnPurchase_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeBtnPanel.this.lblOpening_.setText("Opening Web Page: http://www.dbwrench.com/purchase/pp/purchase_pp_standard.shtml ...");
                CodeBtnPanel.this.openWebPage();
            }
        });
        this.btnClose_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (CodeBtnPanel.this.parentContainer_ != null) {
                    GuiHelper.closeParent(CodeBtnPanel.this.parentContainer_);
                }
            }
        });
    }

    private void openWebPage() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    try {
                        SysUtil.openPurchasePage("http://www.dbwrench.com/purchase/pp/purchase_pp_standard.shtml");
                        CodeBtnPanel.this.lblOpening_.setText("");
                    }
                    catch (Exception e) {
                        CodeBtnPanel.this.showBrowserFailedMsg();
                        CodeBtnPanel.this.lblOpening_.setText("");
                    }
                }
            });
        }
        catch (Exception e) {
            this.showBrowserFailedMsg();
        }
    }

    private void showBrowserFailedMsg() {
        GuiMessageHelper.showWarningMsg(null, "Web Browser Launch", "Could not open web browser on this system.");
    }

    private void layoutPanel() {
        this.setLayout(new GridLayout(2, 1));
        this.add(this.getStatusPanel());
        this.add(this.getBtnPanel());
        GuiHelper.addEmptyBorder(this);
    }

    public JPanel getBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.btnPurchase_);
        panel.add(Box.createGlue());
        panel.add(this.btnUpdate_);
        if (!this.useLargeBorder_) {
            panel.add(Box.createHorizontalStrut(5));
            panel.add(this.btnClose_);
        }
        Border border = BorderFactory.createEmptyBorder(5, 10, 10, 10);
        panel.setBorder(border);
        return panel;
    }

    public JPanel getStatusPanel() {
        JPanel panel = new JPanel();
        panel.add(this.lblOpening_);
        return panel;
    }

    private void setCosmetics() {
        this.lblOpening_.setHorizontalAlignment(0);
    }
}

