/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.search;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.search.ISearchCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.text.HarrandHighlightPainter;
import com.harrand.coregui.undo.BasicUndoEditListener;
import com.harrand.coregui.undo.ReplaceTextUndoableEdit;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public final class TextCompSearchCtrl
implements ISearchCtrl {
    private JTextComponent textComp_;
    private Highlighter highlighter_;
    private Highlighter.HighlightPainter highlightPainterAll_ = new HarrandHighlightPainter(Color.PINK);
    private Highlighter.HighlightPainter highlightPainterCurrent_ = new HarrandHighlightPainter(Colors.getBlueGreenMild());
    private Document doc_;
    private BasicUndoEditListener undoableEditListener_;
    private String findText_;
    private String sourceText_;
    private String lastFindText_ = "";
    private String lastReplaceText_ = "";
    private int findLength_;
    private int sourceLength_;
    private int originalPos_;
    private boolean wrapSearch_;
    private boolean wholeWordOnly_;
    private boolean matchCase_;

    public TextCompSearchCtrl(JTextComponent textComp, BasicUndoEditListener undoableEditListener) {
        this.textComp_ = textComp;
        this.doc_ = this.textComp_.getDocument();
        this.undoableEditListener_ = undoableEditListener;
        this.highlighter_ = this.textComp_.getHighlighter();
    }

    private void setTexts(String findText, IOptionMgr searchOptions) {
        this.removeHighlights();
        this.findText_ = new String(findText);
        this.sourceText_ = new String(GuiHelper.getTextDocumentText(this.doc_));
        this.originalPos_ = this.textComp_.getCaretPosition();
        this.originalPos_ = StrHelper.getCursorWordStart(this.sourceText_, this.originalPos_);
        this.findLength_ = this.findText_.length();
        this.sourceLength_ = this.sourceText_.length();
        this.wholeWordOnly_ = searchOptions.getBoolValue("search.whole.word.only");
        this.matchCase_ = searchOptions.getBoolValue("search.match.case");
        this.wrapSearch_ = searchOptions.getBoolValue("search.wrap.search");
        if (!this.matchCase_) {
            this.findText_ = this.findText_.toLowerCase();
            this.sourceText_ = this.sourceText_.toLowerCase();
        }
    }

    private boolean isRepeatFind() {
        return this.findText_.equals(this.lastFindText_);
    }

    private boolean isRepeatReplace(String replaceText) {
        return this.isRepeatFind() && replaceText.equals(this.lastReplaceText_);
    }

    @Override
    public void clear() {
        this.removeHighlights();
        this.lastFindText_ = "";
        this.lastReplaceText_ = "";
    }

    @Override
    public void findAll(String findStr, IOptionMgr searchOptions) {
        this.setTexts(findStr, searchOptions);
        List positions = this.findPositions(0);
        if (this.checkTextFound(positions)) {
            this.highlightAll(positions);
        }
    }

    @Override
    public void findNext(String findStr, IOptionMgr searchOptions) {
        this.setTexts(findStr, searchOptions);
        int startPos = this.isRepeatFind() ? this.originalPos_ + this.findLength_ : this.originalPos_;
        List positions = this.findPositions(startPos);
        if (this.checkTextFound(positions)) {
            int pos = (Integer)positions.get(0);
            this.highlightFind(pos, this.highlightPainterCurrent_);
            this.highlightAll(positions);
            this.textComp_.setCaretPosition(pos);
        }
        this.lastFindText_ = findStr;
    }

    @Override
    public String getWordAtCursor() {
        String text = new String(GuiHelper.getTextDocumentText(this.doc_));
        return StrHelper.getWordAtPos(text, this.textComp_.getCaretPosition());
    }

    @Override
    public void replaceAll(String findStr, String replaceStr, IOptionMgr searchOptions) {
        this.setTexts(findStr, searchOptions);
        List positions = this.findPositions(0);
        if (this.checkTextFound(positions)) {
            this.doReplaceEdit(replaceStr, positions);
        }
    }

    @Override
    public void replaceNext(String findStr, String replaceStr, IOptionMgr searchOptions) {
        this.setTexts(findStr, searchOptions);
        int startPos = this.isRepeatReplace(replaceStr) ? this.originalPos_ + replaceStr.length() : this.originalPos_;
        List positions = this.findPositions(startPos);
        if (this.checkTextFound(positions)) {
            int pos = (Integer)positions.get(0);
            this.replace(pos, replaceStr);
            this.textComp_.setCaretPosition(pos);
            if (positions.size() > 1) {
                int lengthDiff = replaceStr.length() - this.findLength_;
                int nextPos = (Integer)positions.get(1);
                this.highlightFind(nextPos += lengthDiff, this.highlightPainterCurrent_);
                this.textComp_.setCaretPosition(nextPos);
            }
        }
        this.lastReplaceText_ = replaceStr;
    }

    private int findNextPosition(int startPosition) {
        int pos = this.sourceText_.indexOf(this.findText_, startPosition);
        return pos;
    }

    private boolean checkWholeWord(int position) {
        if (this.wholeWordOnly_) {
            return StrHelper.isWholeWord(position, this.findLength_, this.sourceText_);
        }
        return true;
    }

    private List findPositions(int startPosition) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        int pos = startPosition;
        while ((pos = this.findNextPosition(pos)) >= 0) {
            if (this.checkWholeWord(pos)) {
                positions.add(new Integer(pos));
            }
            pos += this.findLength_;
        }
        if (this.wrapSearch_) {
            pos = this.findNextPosition(pos);
            while (pos >= 0 && pos < startPosition) {
                if (this.checkWholeWord(pos)) {
                    positions.add(new Integer(pos));
                }
                pos += this.findLength_;
                pos = this.findNextPosition(pos);
            }
        }
        return positions;
    }

    private boolean checkTextFound(List positions) {
        if (positions.isEmpty()) {
            this.showNotFoundMsg();
            return false;
        }
        return true;
    }

    private void replace(int pos, String replaceStr) {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        positions.add(new Integer(pos));
        this.doReplaceEdit(replaceStr, positions);
    }

    private void doReplaceEdit(String replaceStr, List positions) {
        ReplaceTextUndoableEdit undoableEdit = new ReplaceTextUndoableEdit(this.textComp_, this.undoableEditListener_, this.findText_, replaceStr, positions);
        undoableEdit.exec();
    }

    private void showNotFoundMsg() {
        GuiMessageHelper.showOptionPaneMsg(null, FileHelper.getRes("search.title"), FileHelper.getRes("search.text.not.found") + ": " + this.findText_, 0);
    }

    private void highlightAll(List positions) {
        for (Integer intObj : positions) {
            this.highlightFind(intObj, this.highlightPainterAll_);
        }
    }

    private void highlightFind(int pos, Highlighter.HighlightPainter painter) {
        try {
            this.highlighter_.addHighlight(pos, pos + this.findLength_, painter);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    private void removeHighlights() {
        Highlighter.Highlight[] hilites = this.highlighter_.getHighlights();
        for (int i = 0; i < hilites.length; ++i) {
            if (!(hilites[i].getPainter() instanceof HarrandHighlightPainter)) continue;
            this.highlighter_.removeHighlight(hilites[i]);
        }
    }
}

