/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.search;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.IErgonomicPanel;
import com.harrand.coreclasses.list.BasicHistoryListSrv;
import com.harrand.coreclasses.list.IHistoryListSrv;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.search.ISearchCtrl;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.option.BasicOptionMgrSvr;
import com.harrand.util.FileHelper;
import com.harrand.util.Validator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class SearchPanel
extends JPanel
implements ISized,
IObserver,
IErgonomicPanel {
    private ISearchCtrl searchCtrl_;
    private BasicOptionMgrSvr mgrSvr_ = new BasicOptionMgrSvr();
    private BasicHistoryListSrv historyListServer_ = BasicHistoryListSrv.instance();
    private JComboBox cboFind_;
    private JComboBox cboReplace_;
    private DefaultComboBoxModel cboModelFind_;
    private DefaultComboBoxModel cboModelReplace_;
    private JButton btnFind_;
    private JButton btnReplace_;
    private JButton btnReplaceAll_;
    private JCheckBox chkMatchCase_;
    private JCheckBox chkWholeWordsOnly_;
    private JCheckBox chkWrapSearch_;
    private JLabel lblFind_;
    private JLabel lblReplace_;
    private String findWord_ = "";
    private String replaceWord_ = "";
    private SwingThemeCtrl themeCtrl_;

    public SearchPanel(ISearchCtrl searchCtrl) {
        this.searchCtrl_ = searchCtrl;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.buildPanel();
        this.historyListServer_.addObserver(this);
    }

    public void init() {
        this.cboFind_.setSelectedItem(this.searchCtrl_.getWordAtCursor());
        this.cboReplace_.setSelectedItem("");
    }

    private void buildPanel() {
        this.buildControls();
        this.layoutPanel();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        this.lblFind_ = new JLabel(FileHelper.getRes("search.find.label"));
        this.lblReplace_ = new JLabel(FileHelper.getRes("search.replace.label"));
        this.btnFind_ = new JButton(FileHelper.getRes("search.find.label"));
        this.btnReplace_ = new JButton(FileHelper.getRes("search.replace.label"));
        this.btnReplaceAll_ = new JButton(FileHelper.getRes("search.replace.all.label"));
        this.cboFind_ = new JComboBox();
        this.cboFind_.setEditable(true);
        this.cboReplace_ = new JComboBox();
        this.cboReplace_.setEditable(true);
        this.refreshComboData();
        IOptionMgr optionMgr = this.mgrSvr_.getOptionMgr("search.option.mgr");
        this.chkMatchCase_ = new JCheckBox(this.getCheckBoxLabel("search.match.case"), optionMgr.getBoolValue("search.match.case"));
        this.chkWrapSearch_ = new JCheckBox(this.getCheckBoxLabel("search.wrap.search"), optionMgr.getBoolValue("search.wrap.search"));
        this.chkWholeWordsOnly_ = new JCheckBox(this.getCheckBoxLabel("search.whole.word.only"), optionMgr.getBoolValue("search.whole.word.only"));
    }

    private String getCheckBoxLabel(String optionName) {
        return FileHelper.getRes(optionName + ".label");
    }

    private void layoutPanel() {
        JPanel centerPanel = this.getCenterPanel();
        JPanel buttonPanel = this.getButtonPanel();
        this.setLayout(new BorderLayout());
        this.add((Component)centerPanel, "Center");
        this.add((Component)buttonPanel, "East");
    }

    private JPanel getCenterPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        panel.setLayout(gbl);
        JPanel checkBoxPanel = new JPanel(new GridLayout(2, 2));
        checkBoxPanel.add(this.chkMatchCase_);
        checkBoxPanel.add(this.chkWholeWordsOnly_);
        checkBoxPanel.add(this.chkWrapSearch_);
        JLabel lblBlank = new JLabel("");
        this.themeCtrl_.process(panel);
        this.themeCtrl_.process(checkBoxPanel);
        this.themeCtrl_.process(lblBlank);
        GridBagConstraints gbc = new GridBagConstraints();
        int row = 0;
        GuiHelper.addGridbagPair(this.lblFind_, this.cboFind_, gbc, panel, row++);
        GuiHelper.addGridbagPair(this.lblReplace_, this.cboReplace_, gbc, panel, row++);
        GuiHelper.addGridbagPair(lblBlank, checkBoxPanel, gbc, panel, row++);
        return panel;
    }

    private JPanel getButtonPanel() {
        int EDGE = 4;
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(this.btnFind_);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(this.btnReplace_);
        panel.add(Box.createRigidArea(new Dimension(0, 5)));
        panel.add(this.btnReplaceAll_);
        panel.setBorder(BorderFactory.createEmptyBorder(EDGE, EDGE, EDGE, EDGE));
        this.themeCtrl_.process(panel);
        return panel;
    }

    private void setNames() {
        this.cboFind_.setName("cboFind");
        this.cboReplace_.setName("cboReplace");
        this.btnFind_.setName("btnFind");
        this.btnReplace_.setName("btnReplace");
        this.btnReplaceAll_.setName("btnReplaceAll");
        this.chkMatchCase_.setName("chkMatchCase");
        this.chkWholeWordsOnly_.setName("chkWholeWordsOnly");
        this.chkWrapSearch_.setName("chkWrapSearch");
    }

    private void setCosmetics() {
        this.setAlignments();
        this.setMnemonics();
        this.themeCtrl_.process(this.lblFind_);
        this.themeCtrl_.process(this.lblReplace_);
        this.themeCtrl_.process(this.cboFind_);
        this.themeCtrl_.process(this.cboReplace_);
        this.themeCtrl_.process(this.btnFind_);
        this.themeCtrl_.process(this.btnReplace_);
        this.themeCtrl_.process(this.btnReplaceAll_);
        this.themeCtrl_.process(this.chkMatchCase_);
        this.themeCtrl_.process(this.chkWholeWordsOnly_);
        this.themeCtrl_.process(this.chkWrapSearch_);
        this.themeCtrl_.process(this);
    }

    private void setAlignments() {
        this.btnFind_.setMaximumSize(this.btnReplaceAll_.getMinimumSize());
        this.btnReplace_.setMaximumSize(this.btnReplaceAll_.getMinimumSize());
        this.lblFind_.setHorizontalAlignment(2);
        this.lblReplace_.setHorizontalAlignment(2);
    }

    private void setMnemonics() {
        this.btnFind_.setMnemonic('F');
        this.btnReplace_.setMnemonic('R');
        this.btnReplaceAll_.setMnemonic('A');
        this.chkMatchCase_.setMnemonic('M');
        this.chkWholeWordsOnly_.setMnemonic('O');
        this.chkWrapSearch_.setMnemonic('W');
    }

    private void refreshComboData() {
        List findItems = this.historyListServer_.getList(0);
        this.cboModelFind_ = new DefaultComboBoxModel<Object>(findItems.toArray());
        this.cboFind_.setModel(this.cboModelFind_);
        this.cboFind_.setSelectedItem(this.findWord_);
        List replaceItems = this.historyListServer_.getList(1);
        this.cboModelReplace_ = new DefaultComboBoxModel<Object>(replaceItems.toArray());
        this.cboReplace_.setModel(this.cboModelReplace_);
        this.cboReplace_.setSelectedItem(this.replaceWord_);
    }

    private void addListeners() {
        this.btnFind_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.findText();
            }
        });
        this.btnReplace_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.replaceText(false);
            }
        });
        this.btnReplaceAll_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SearchPanel.this.replaceText(true);
            }
        });
    }

    private void findText() {
        String findText = this.getComboText(this.cboFind_);
        if (this.isTextValid(findText)) {
            this.findWord_ = findText;
            this.replaceWord_ = this.getComboText(this.cboReplace_);
            this.searchCtrl_.findNext(findText, this.getSearchProperties());
            this.historyListServer_.addItem(0, findText);
        }
    }

    private void replaceText(boolean replaceAll) {
        String findText = this.getComboText(this.cboFind_);
        String replaceText = this.getComboText(this.cboReplace_);
        if (this.isTextValid(findText)) {
            this.findWord_ = findText;
            this.replaceWord_ = replaceText;
            if (replaceAll) {
                this.searchCtrl_.replaceAll(findText, replaceText, this.getSearchProperties());
            } else {
                this.searchCtrl_.replaceNext(findText, replaceText, this.getSearchProperties());
            }
            this.historyListServer_.addItem(0, findText);
            this.historyListServer_.addItem(1, replaceText);
        }
    }

    private String getComboText(JComboBox combo) {
        Object selectedObj = combo.getSelectedItem();
        if (selectedObj != null) {
            return selectedObj.toString();
        }
        return null;
    }

    private boolean isTextValid(String text) {
        if (Validator.isStringValid(text)) {
            return true;
        }
        GuiMessageHelper.showOptionPaneMsg(null, FileHelper.getRes("search.title"), FileHelper.getRes("search.err.find.text.empty"), 0);
        return false;
    }

    private IOptionMgr getSearchProperties() {
        IOptionMgr optionMgr = this.mgrSvr_.getOptionMgr("search.option.mgr");
        optionMgr.setBoolValue("search.match.case", this.chkMatchCase_.isSelected());
        optionMgr.setBoolValue("search.wrap.search", this.chkWrapSearch_.isSelected());
        optionMgr.setBoolValue("search.whole.word.only", this.chkWholeWordsOnly_.isSelected());
        return optionMgr;
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.FIND;
    }

    @Override
    public String getTitle() {
        return FileHelper.getRes("search.title");
    }

    @Override
    public String getToolTip() {
        return FileHelper.getRes("search.tooltip");
    }

    @Override
    public JButton getDefaultButton() {
        return this.btnFind_;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(50, 50, 390, 180);
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(IHistoryListSrv.class.getName())) {
            this.refreshComboData();
        }
    }
}

