/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.query;

import com.harrand.coreclasses.dataEntry.IDataEditPanel;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.query.IQueryParameterCtrl;
import com.harrand.coreclasses.query.IQueryTableCtrl;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.dialog.DataEditDlg;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.query.QueryParameterPanel;
import com.harrand.util.FileHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class QueryTablePanel
extends JPanel
implements IObservable,
ISized,
ITitled {
    private IQueryTableCtrl queryTableCtrl_;
    private IQueryParameterCtrl parameterCtrl_;
    private QueryParameterPanel parameterPanel_;
    private String displayName_;
    private List groupIncludes_;
    private List selectedCheckBoxNames_;
    private JScrollPane scrTable_;
    private JTable table_;
    private BasicObservable observable_ = new BasicObservable();
    private JButton btnQueryParameters_ = new JButton(Icons.OPTIONS);
    private JButton btnRefresh_ = new JButton(Icons.REFRESH);
    private JButton btnDetails_ = new JButton(Icons.ZOOM_IN);
    private JButton btnDelete_ = new JButton(Icons.MINUS);
    private JButton btnAdd_ = new JButton(Icons.ADD);
    private ActionListener lisRefresh_;
    private ActionListener lisQueryParameters_;
    private ActionListener lisTupleAdd_;
    private ActionListener lisTupleDelete_;
    private ActionListener lisTupleDetails_;
    private ActionListener lisTupleItem_;
    private Frame dlgOwner_;
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
    private int idColIndex_ = -1;

    public QueryTablePanel(IQueryTableCtrl queryTableCtrl) {
        this.queryTableCtrl_ = queryTableCtrl;
        this.parameterCtrl_ = this.queryTableCtrl_.getQueryParameterCtrl();
        this.parameterPanel_ = new QueryParameterPanel(this.parameterCtrl_);
        this.parameterPanel_.selectCheckBoxesByName(this.parameterCtrl_.getSelectedPreset(0), true);
        this.groupIncludes_ = this.parameterPanel_.getValuesSelectedInGroups();
        this.displayName_ = this.queryTableCtrl_.getTupleDisplayName();
        this.setupGui();
        this.refresh();
        String idName = this.queryTableCtrl_.getIdName();
        this.idColIndex_ = GuiHelper.getColumnIndex(this.table_, idName);
        if (this.idColIndex_ < 0) {
            System.out.println("QueryTablePanel.could not find ColId for: " + idName);
        }
    }

    public void setDialogOwner(Frame dlgOwner) {
        this.dlgOwner_ = dlgOwner;
    }

    public int getSelectedTupleId() {
        int tupleId = -1;
        if (this.table_.getSelectedRowCount() > 0) {
            int row = this.table_.getSelectedRow();
            String idStr = (String)this.table_.getModel().getValueAt(row, this.idColIndex_);
            tupleId = Integer.parseInt(idStr);
        }
        return tupleId;
    }

    private void setupGui() {
        this.buildListeners();
        this.buildControls();
        this.layoutComponents();
        this.setNames();
        this.setCosmetics();
        this.addListeners();
    }

    private void buildListeners() {
        this.lisQueryParameters_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryTablePanel.this.promptQuerySetting();
            }
        };
        this.lisTupleAdd_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryTablePanel.this.showTupleDetails(0);
            }
        };
        this.lisTupleDetails_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryTablePanel.this.showSelectedTuple();
            }
        };
        this.lisTupleDelete_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryTablePanel.this.deleteSelectedTuples();
            }
        };
        this.lisRefresh_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                QueryTablePanel.this.refresh();
            }
        };
    }

    private void buildControls() {
        this.table_ = new JTable(GuiHelper.getBlankTableModel());
        this.scrTable_ = new JScrollPane(this.table_);
        this.buildButton(this.btnRefresh_, FileHelper.getRes("refresh.label"), this.lisRefresh_);
        this.buildButton(this.btnQueryParameters_, FileHelper.getRes("query.parameter.set.title"), this.lisQueryParameters_);
        this.buildButton(this.btnAdd_, FileHelper.getRes("add.label") + " " + this.displayName_, this.lisTupleAdd_);
        this.buildButton(this.btnDelete_, FileHelper.getRes("delete.label"), this.lisTupleDelete_);
        this.buildButton(this.btnDetails_, FileHelper.getRes("view.details.label"), this.lisTupleDetails_);
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        JPanel buttonPanel = this.getButtonPanel();
        this.add((Component)this.scrTable_, "Center");
        this.add((Component)buttonPanel, "South");
        this.themeCtrl_.process(this);
    }

    private JPanel getButtonPanel() {
        JPanel panel = new JPanel();
        panel.add(this.btnAdd_);
        panel.add(this.btnDelete_);
        panel.add(this.btnRefresh_);
        panel.add(this.btnDetails_);
        panel.add(this.btnQueryParameters_);
        this.themeCtrl_.process(panel);
        return panel;
    }

    private void buildButton(JButton button, String text, ActionListener listener) {
        button.setText(text);
        button.addActionListener(listener);
        this.themeCtrl_.process(button);
    }

    private void addListeners() {
        this.table_.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                block3: {
                    block2: {
                        if (e.getClickCount() == 2) break block2;
                        if (e.getButton() == 2) break block2;
                        if (e.getButton() != 3) break block3;
                    }
                    QueryTablePanel.this.showSelectedTuple();
                }
            }
        });
        this.table_.getSelectionModel().addListSelectionListener(new TableSelectionListener(this.table_));
    }

    public void setCosmetics() {
        this.table_.setAutoResizeMode(0);
        this.themeCtrl_.process(this.table_);
        this.themeCtrl_.process(this.scrTable_);
    }

    public void setNames() {
        this.table_.setName("table");
        this.btnAdd_.setName("btnAdd");
        this.btnDelete_.setName("btnDelete");
        this.btnDetails_.setName("btnDetails");
        this.btnQueryParameters_.setName("btnQueryParameters");
        this.btnRefresh_.setName("btnRefresh");
    }

    public void refresh() {
        this.refreshTable();
    }

    private void refreshTable() {
        int selectedRow = this.table_.getSelectedRow();
        try {
            Object[][] matrix = this.queryTableCtrl_.doQuery(this.groupIncludes_);
            this.table_.setModel(GuiHelper.getTableModel(matrix, true));
            GuiHelper.optimizeTableColumnWidths(this.table_, 500);
            if (selectedRow >= 0 && selectedRow < this.table_.getRowCount()) {
                this.table_.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
            }
        }
        catch (Exception e) {
            GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
        }
    }

    private void promptQuerySetting() {
        List oldSelected = this.parameterPanel_.getSelectedNames();
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, this.parameterPanel_, this.parameterPanel_.getPreferredBounds(), this.parameterPanel_.getTitle());
        dlg.setVisible(true);
        if (dlg.getOkHit()) {
            this.groupIncludes_ = this.parameterPanel_.getValuesSelectedInGroups();
            this.refresh();
        } else {
            this.parameterPanel_.selectCheckBoxesByName(oldSelected, true);
        }
    }

    private void showSelectedTuple() {
        int tupleId = this.getSelectedTupleId();
        if (tupleId > -1) {
            try {
                this.showTupleDetails(tupleId);
            }
            catch (Exception e) {
                GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
            }
        } else {
            GuiMessageHelper.showInputErrMsg(null, FileHelper.getRes("err.title.invalid.selection"), FileHelper.getRes("err.msg.table.row.not.selected"));
        }
    }

    private void showTupleDetails(int tupleId) {
        try {
            IDataEditPanel mainPanel = this.queryTableCtrl_.getEditTuplePanel(tupleId);
            DataEditDlg dlg = new DataEditDlg((JPanel)((Object)mainPanel), this.dlgOwner_);
            dlg.setVisible(true);
            if (dlg.getOkHit()) {
                this.refresh();
            }
        }
        catch (Exception e) {
            GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
        }
    }

    private void deleteSelectedTuples() {
        int selectCount = this.table_.getSelectedRowCount();
        if (selectCount > 0) {
            int[] ids = new int[selectCount];
            int[] rows = this.table_.getSelectedRows();
            for (int i = 0; i < rows.length; ++i) {
                Integer idInt = (Integer)this.table_.getValueAt(rows[i], this.idColIndex_);
                ids[i] = idInt;
            }
            try {
                this.queryTableCtrl_.deleteTuples(ids);
            }
            catch (Exception e) {
                GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
            }
        } else {
            GuiMessageHelper.showInputErrMsg(null, FileHelper.getRes("err.title.invalid.selection"), FileHelper.getRes("err.msg.table.row.not.selected"));
        }
        this.refresh();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.TABLE;
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public String getTitle() {
        return this.queryTableCtrl_.getTupleDisplayName() + " " + FileHelper.getRes("query.label") + " " + FileHelper.getRes("table.label");
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(50, 50, 580, 500);
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }

    public class TableSelectionListener
    implements ListSelectionListener {
        JTable tableInner_;

        TableSelectionListener(JTable table) {
            this.tableInner_ = table;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getSource() == this.tableInner_.getSelectionModel() && this.tableInner_.getRowSelectionAllowed()) {
                QueryTablePanel.this.notifyObservers(new UpdateChain(QueryTablePanel.this.table_));
            }
            if (e.getValueIsAdjusting()) {
                // empty if block
            }
        }
    }
}

