/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.query;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.element.IId;
import com.harrand.coreclasses.element.IdGroup;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.query.IQueryParameterCtrl;
import com.harrand.coregui.Icons;
import com.harrand.coregui.button.IdCheckBox;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.util.FileHelper;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public final class QueryParameterPanel
extends JPanel
implements ITitled,
ISized {
    private IQueryParameterCtrl queryParameterCtrl_;
    private JPanel mainPanel_;
    private Map groupPanelsMap = new HashMap();
    private Map checkBoxesMap_ = new HashMap();
    private SwingThemeCtrl themeCtrl_;
    private boolean displayIdFlag_ = false;

    public QueryParameterPanel(IQueryParameterCtrl queryParameterCtrl) {
        this.queryParameterCtrl_ = queryParameterCtrl;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
    }

    public List getValuesSelectedInGroups() {
        ArrayList<IdGroup> inGroups = new ArrayList<IdGroup>();
        for (IdGroup allGroup : this.queryParameterCtrl_.getIdGroups()) {
            ArrayList<IId> selectedIds = new ArrayList<IId>();
            for (IId id : allGroup.getIds()) {
                IdCheckBox checkBox = (IdCheckBox)this.checkBoxesMap_.get(id.getName());
                if (checkBox.isSelected()) {
                    selectedIds.add(id);
                }
                if (!checkBox.getText().equals("")) continue;
                selectedIds.add(id);
            }
            IdGroup inGroup = new IdGroup(allGroup.getName(), allGroup.getAbbr(), allGroup.getDisplayName(), selectedIds);
            inGroups.add(inGroup);
        }
        return inGroups;
    }

    public void setDisplayIdFlag(boolean displayIdFlag) {
        this.displayIdFlag_ = displayIdFlag;
    }

    private void setupGui() {
        this.layoutPanel();
    }

    private void layoutPanel() {
        this.mainPanel_ = new JPanel(new FlowLayout());
        this.add(this.mainPanel_);
        this.themeCtrl_.process(this.mainPanel_);
        this.addGroupPanels();
    }

    private void addGroupPanels() {
        for (IdGroup group : this.queryParameterCtrl_.getIdGroups()) {
            this.addGroupPanel(group);
        }
    }

    private void addGroupPanel(IdGroup idGroup) {
        int count = idGroup.getIdCount();
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(count - 1, 1));
        for (IId id : idGroup.getIds()) {
            IdCheckBox checkBox = new IdCheckBox(id);
            this.checkBoxesMap_.put(id.getName(), checkBox);
            if (!id.getName().equals("")) {
                panel.add(checkBox);
            }
            this.themeCtrl_.process(checkBox);
        }
        panel.setBorder(BorderFactory.createTitledBorder(idGroup.getDisplayName()));
        this.themeCtrl_.process(panel);
        this.mainPanel_.add(panel);
    }

    public List getSelectedNames() {
        ArrayList<String> names = new ArrayList<String>();
        for (IdCheckBox checkBox : this.checkBoxesMap_.values()) {
            if (!checkBox.isSelected()) continue;
            names.add(checkBox.getId().getName());
        }
        return names;
    }

    public void selectCheckBoxes(List idGroups, boolean selectFlag) {
        for (IdGroup idGroup : idGroups) {
            for (IId id : idGroup.getIds()) {
                this.selectCheckBox(id.getName(), selectFlag);
            }
        }
    }

    public void selectAllCheckBoxes(boolean selectFlag) {
        for (IdCheckBox checkBox : this.checkBoxesMap_.values()) {
            checkBox.setSelected(selectFlag);
        }
    }

    public void selectCheckBoxesByName(List names, boolean selectFlag) {
        Iterator it = names.iterator();
        while (it.hasNext()) {
            this.selectCheckBox((String)it.next(), selectFlag);
        }
    }

    private void selectCheckBox(String checkBoxName, boolean selectFlag) {
        Object obj = this.checkBoxesMap_.get(checkBoxName);
        if (obj != null) {
            JCheckBox checkBox = (JCheckBox)obj;
            checkBox.setSelected(selectFlag);
        } else {
            StrHelper.throwProgExcept("Map does not contain check box: " + checkBoxName);
        }
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(50, 50, 650, 500);
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.TABLE;
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }

    @Override
    public String getTitle() {
        return FileHelper.getRes("query.parameter.set.title");
    }
}

