/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel.viewport;

import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.panel.viewport.ViewportCoordinateMover;
import com.harrand.coregui.panel.viewport.ViewportMoveCtrl;
import com.harrand.dbwrenchgui.db.worker.helper.DbWorkerUpdateHelper;
import com.harrand.util.LogUtil;
import java.awt.Point;
import java.util.List;

public class ViewportMoveWorker
extends SwingWorker<Void, Point> {
    private DbWorkerUpdateHelper updateHelper = new DbWorkerUpdateHelper();
    private ViewportMoveCtrl vpMoveCtrl;
    private int nextX;
    private int nextY;

    @Override
    protected Void doInBackground() throws Exception {
        ViewportCoordinateMover hMover = this.vpMoveCtrl.getHorzMover();
        ViewportCoordinateMover vMover = this.vpMoveCtrl.getVertMover();
        boolean hDone = false;
        boolean vDone = false;
        boolean done = false;
        while (!done) {
            this.nextX = hMover.getNextValue();
            this.nextY = vMover.getNextValue();
            this.publish(new Point(this.nextX, this.nextY));
            this.delaySleep(2);
            hDone = hMover.isDone();
            vDone = vMover.isDone();
            done = hDone && vDone;
        }
        return null;
    }

    @Override
    protected void process(List<Point> chunks) {
        super.process(chunks);
        LogUtil.logMsg("vpMoveWorker.time: " + System.currentTimeMillis());
        this.vpMoveCtrl.getViewport().setViewPosition(new Point(this.nextX, this.nextY));
    }

    public void startSlowMove(ViewportMoveCtrl vpMoveCtrl) {
        this.vpMoveCtrl = vpMoveCtrl;
        try {
            this.execute();
        }
        catch (Exception ex) {
            this.updateHelper.handleExecuteException(ex, this.getClass().getName());
        }
    }

    public void delaySleep(int milliSec) {
        try {
            Thread.sleep(milliSec);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }
}

