/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel.viewport;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.panel.viewport.ViewportAutoScrollCtrl;
import com.harrand.coregui.panel.viewport.ViewportCoordinateMover;
import com.harrand.coregui.panel.viewport.ViewportMoveRunnable;
import com.harrand.util.LogUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JViewport;

public class ViewportMoveCtrl {
    private JViewport viewport;
    private ViewportCoordinateMover horzMover;
    private ViewportCoordinateMover vertMover;
    private BasicObservable observable_ = new BasicObservable();
    private int fontSize_ = 11;
    private double zoomLevel_ = 1.0;
    public static final int STEP_DELAY = 2;

    public ViewportMoveCtrl(JViewport viewport) {
        this.viewport = viewport;
        this.horzMover = new ViewportCoordinateMover(viewport, 0);
        this.vertMover = new ViewportCoordinateMover(viewport, 1);
    }

    public void setZoomLevel(double zoomLevel) {
        this.zoomLevel_ = zoomLevel;
    }

    public void setFontSize(int fontSize) {
        this.fontSize_ = fontSize;
    }

    private void initSubMover(Point newPt) {
        this.horzMover.setZoomLevel(this.zoomLevel_);
        this.vertMover.setZoomLevel(this.zoomLevel_);
        this.horzMover.setFontSize(this.fontSize_);
        this.vertMover.setFontSize(this.fontSize_);
        this.horzMover.setNewValue(newPt.x);
        this.vertMover.setNewValue(newPt.y);
    }

    public ViewportCoordinateMover getHorzMover() {
        return this.horzMover;
    }

    public ViewportCoordinateMover getVertMover() {
        return this.vertMover;
    }

    public JViewport getViewport() {
        return this.viewport;
    }

    public void moveViewSlowly(Point newPt) {
        this.initSubMover(newPt);
        ViewportMoveRunnable runnable = new ViewportMoveRunnable(this);
        new Thread(runnable).start();
    }

    private void moveSlowlyGuts() {
        boolean hDone = false;
        boolean vDone = false;
        boolean done = false;
        while (!done) {
            int nextX = this.horzMover.getNextValue();
            int nextY = this.vertMover.getNextValue();
            this.viewport.setViewPosition(new Point(nextX, nextY));
            this.notifyObservers(null);
            hDone = this.horzMover.isDone();
            vDone = this.vertMover.isDone();
            done = hDone && vDone;
            this.delaySleep(2);
        }
    }

    public void moveViewDirectly(Point newPt) {
        this.initSubMover(newPt);
        boolean hDone = false;
        boolean vDone = false;
        boolean done = false;
        while (!done) {
            this.viewport.setViewPosition(newPt);
            this.viewport.validate();
            hDone = this.horzMover.isDone();
            vDone = this.vertMover.isDone();
            done = hDone && vDone;
        }
    }

    public void autoScrollToShowPoint(Point mousePt, Rectangle maxBounds) {
        Point panelPt;
        ViewportAutoScrollCtrl autoScrollCtrl = new ViewportAutoScrollCtrl();
        Rectangle vpRect = this.viewport.getViewRect();
        Point newPoint = autoScrollCtrl.autoScrollToShowPoint(vpRect, panelPt = new Point(vpRect.x + mousePt.x, vpRect.y + mousePt.y), maxBounds);
        if (newPoint != null) {
            this.moveViewSlowly(newPoint);
        }
    }

    public ITestResult checkMoveOk(Point newPt, Dimension panelSz) {
        boolean yOk;
        DataEntryResult result = new DataEntryResult(true);
        long newX = Math.round(newPt.getX());
        long newY = Math.round(newPt.getY());
        double maxX = panelSz.getWidth() - this.viewport.getSize().getWidth();
        double maxY = panelSz.getHeight() - this.viewport.getSize().getHeight();
        boolean xOk = newX == 0L || (double)newX < maxX;
        boolean bl = yOk = newY == 0L || (double)newY < maxY;
        if (!xOk || !yOk) {
            result = new DataEntryResult(false, "Beyond Viewport Limit", "Attempted to move viewport beyond panel limit.");
        }
        return result;
    }

    public void delaySleep(int milliSec) {
        try {
            Thread.sleep(milliSec);
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

