/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.IErgonomicPanel;
import com.harrand.coregui.display.SwingThemeCtrl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public final class TabbedPanel
extends JPanel
implements ISized {
    private List panels_;
    private JTabbedPane tabPane_;
    private SwingThemeCtrl themeCtrl_;

    public TabbedPanel(List ergonomicPanels) throws Exception {
        this.checkInput(ergonomicPanels);
        this.panels_ = ergonomicPanels;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.buildPanel();
        this.setCosmetics();
        this.setNames();
    }

    private void buildPanel() {
        this.setLayout(new BorderLayout());
        this.tabPane_ = new JTabbedPane(3);
        for (IErgonomicPanel panel : this.panels_) {
            this.tabPane_.addTab(panel.getTitle(), panel.getIcon(), (JPanel)((Object)panel), panel.getToolTip());
        }
        this.add((Component)this.tabPane_, "Center");
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.tabPane_);
    }

    private void setNames() {
        this.tabPane_.setName("tabPane");
    }

    private void checkInput(List panels) throws Exception {
        for (Object obj : panels) {
            if (!(obj instanceof JPanel)) {
                throw new Exception(obj.toString() + " is not an instance of JPanel.");
            }
            if (obj instanceof IErgonomicPanel) continue;
            throw new Exception(obj.toString() + " is not an instance of IErgonomicPanel.");
        }
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(400, 150, 250, 200);
    }
}

