/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel;

import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.interfaces.IAnimation;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.script.IServerScriptCtrl;
import com.harrand.coreclasses.text.QuickTimeFormat;
import com.harrand.coreclasses.text.scanner.BasicKeywordScanner;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.Animator;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.label.StatusLabel;
import com.harrand.coregui.panel.StatusPanel;
import com.harrand.coregui.text.TextPanel;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class ServerScriptPanel
extends JPanel
implements IObserver,
IAnimation {
    private IServerScriptCtrl scriptCtrl_;
    boolean toServer_;
    private StatusPanel statusPanel_;
    private JButton btnClear_;
    private JLabel lblMileStone_;
    private TextPanel txtMilestone_;
    private Animator animator_ = new Animator();
    private long startTime_;
    private boolean updateTime_;
    private boolean useCornerIcon_;
    private String readyStr_;
    private SwingThemeCtrl themeCtrl_;
    private final int STATUS_ID = 0;
    private final int ELAPSED_TIME_ID = 1;

    public ServerScriptPanel(IServerScriptCtrl scriptCtrl, boolean useCornerIcon) {
        this.scriptCtrl_ = scriptCtrl;
        this.scriptCtrl_.addObserver(this);
        this.toServer_ = this.scriptCtrl_.toServer();
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.useCornerIcon_ = useCornerIcon;
        this.buildPanel();
        this.setCosmetics();
        this.addListeners();
        this.setNames();
    }

    public void setStatusMsg(String msg) {
        this.statusPanel_.getStatusLabel(0).setText(msg);
    }

    public void setElapsedMsg(String timeStr) {
        this.statusPanel_.getStatusLabel(1).setText(timeStr);
    }

    private void buildPanel() {
        this.buildControls();
        this.buildStatusPanel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.btnClear_);
        GuiHelper.addTopBottomBorder(buttonPanel);
        JPanel pnlLog = new JPanel();
        pnlLog.setLayout(new BorderLayout(0, 1));
        JLabel lblTitle = GuiHelper.getTitleLabel("Messages Log");
        pnlLog.add((Component)lblTitle, "North");
        pnlLog.add((Component)this.txtMilestone_, "Center");
        pnlLog.add((Component)buttonPanel, "South");
        if (this.useCornerIcon_) {
            GuiHelper.addBodyPanelBorder(pnlLog);
        } else {
            GuiHelper.addEmptyBorder(pnlLog);
        }
        this.themeCtrl_.process(buttonPanel);
        this.themeCtrl_.process(pnlLog);
        this.setLayout(new BorderLayout());
        this.add((Component)pnlLog, "Center");
        this.add((Component)this.statusPanel_, "South");
    }

    private void buildControls() {
        this.btnClear_ = new JButton(ResMgr.getRes("edit.clear"), Icons.ERASE);
        this.btnClear_.setToolTipText(ResMgr.getRes("log.clear.tooltip"));
        this.lblMileStone_ = new JLabel(ResMgr.getRes("update.log.label"));
        this.txtMilestone_ = new TextPanel("");
        this.txtMilestone_.setKeywordScanner(new BasicKeywordScanner(new String[]{"note", "error", "err"}, "Error"));
        this.txtMilestone_.setEditable(false);
    }

    private void buildStatusPanel() {
        this.readyStr_ = ResMgr.getRes("ready");
        ArrayList<StatusLabel> labels = new ArrayList<StatusLabel>();
        StatusLabel mileStoneStatus = new StatusLabel(90, this.readyStr_, null);
        StatusLabel timeStatus = new StatusLabel(10, "", Icons.CLOCK);
        this.animator_.setIconLabel(mileStoneStatus);
        this.animator_.setTimeLabel(timeStatus);
        labels.add(mileStoneStatus);
        labels.add(timeStatus);
        this.statusPanel_ = new StatusPanel(labels, this.useCornerIcon_);
    }

    private void setCosmetics() {
        this.btnClear_.setMnemonic(76);
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.lblMileStone_);
        this.themeCtrl_.process(this.txtMilestone_);
        this.themeCtrl_.process(this.btnClear_);
    }

    private void setNames() {
        this.lblMileStone_.setName("lblMileStone");
        this.txtMilestone_.setName("txtMilestone");
        this.statusPanel_.setName("statusPanel");
        this.btnClear_.setName("btnClear");
    }

    @Override
    public void startAnimation() {
        this.animator_.start();
    }

    @Override
    public void stopAnimation() {
        this.animator_.stop();
    }

    public void addListeners() {
        this.btnClear_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ServerScriptPanel.this.clearDisplay();
            }
        });
    }

    public ITestResult startScript() {
        this.updateTime_ = false;
        if (this.scriptCtrl_.preProcess()) {
            this.updateTime_ = true;
            this.startTime_ = System.currentTimeMillis();
            this.animator_.start();
            this.txtMilestone_.scrollDown();
            this.txtMilestone_.setText(this.txtMilestone_.getText() + "\n****************************************************\n");
            this.displayElapsedTime();
            this.updateTime_ = false;
            this.txtMilestone_.scrollDown();
            this.scriptCtrl_.postProcess();
            this.txtMilestone_.scrollDown();
            return new DataEntryResult(true, "Script Done", "Script Completed");
        }
        return new DataEntryResult(false, "Script Stopped", "Script cancelled or failed during pre-process");
    }

    private void displayElapsedTime() {
        if (this.updateTime_) {
            long stopTime = System.currentTimeMillis();
            long elapsed = stopTime - this.startTime_;
            this.statusPanel_.getStatusLabel(1).setText(QuickTimeFormat.msToTime(elapsed));
        }
    }

    private void clearDisplay() {
        this.txtMilestone_.setText("");
        this.statusPanel_.getStatusLabel(1).setText("");
        String currentTextLc = this.statusPanel_.getStatusLabel(0).getText().toLowerCase();
        if (currentTextLc.indexOf("complete") >= 0) {
            this.statusPanel_.getStatusLabel(0).setText(this.readyStr_);
        }
    }

    public void reset() {
        this.clearDisplay();
    }

    @Override
    public void update(UpdateChain chain) {
        if (chain.hasInteface(IServerScriptCtrl.class.getName())) {
            String milestoneDesc = this.scriptCtrl_.getMilestoneDesc() + "\n";
            this.txtMilestone_.appendText(milestoneDesc);
            String statusStr = this.scriptCtrl_.getStatusDesc();
            this.setStatusMsg(statusStr);
            this.txtMilestone_.scrollDown();
        }
    }
}

