/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel;

import com.harrand.coreclasses.dataEntry.IChildComponent;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;

public final class RuntimeInfoPanel
extends JPanel
implements ISized,
IChildComponent,
ITitled {
    private String appName_;
    private String appVersion_;
    private ImageIcon appIcon_;
    private JPanel infoPanel_;
    private JPanel iconPanel_;
    private XpHeaderPanel header_;
    private JPanel btnPanel_;
    private RootPaneContainer parentContainer_;
    private JLabel[] lblStatic_ = new JLabel[16];
    private JTextField[] txtValues_ = new JTextField[16];
    private SwingThemeCtrl ctrl_;
    private Runtime runtime_ = Runtime.getRuntime();
    private JButton btnRefresh_ = new JButton(ResMgr.getRes("refresh.label"));
    private JButton btnClose_ = new JButton(ResMgr.getRes("close"));
    private ActionListener lisRefresh_;
    private ActionListener lisClose_;
    private String spacing_ = "       ";
    private static final int LABEL_COUNT = 16;
    public static final String TITLE = "Runtime Information";

    public RuntimeInfoPanel(String appName, String appVersion, ImageIcon appIcon) {
        this.checkInputs(appName, appVersion);
        this.ctrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.appName_ = appName;
        this.appVersion_ = appVersion;
        this.appIcon_ = appIcon;
        this.buildPanel();
        this.addListeners();
        this.setNames();
        this.setCosmetics();
        this.refresh();
    }

    private void buildPanel() {
        this.header_ = new XpHeaderPanel(TITLE, null);
        this.buildInfoPanel();
        this.buildBtnPanel();
        this.setLayout(new BorderLayout(12, 4));
        this.ctrl_.process(this);
        this.add((Component)this.header_, "North");
        this.add((Component)this.infoPanel_, "Center");
        this.add((Component)this.getSouthPanel(), "South");
    }

    private void buildInfoPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.infoPanel_ = new JPanel();
        this.infoPanel_.setLayout(gbl);
        GuiHelper.addBodyPanelBorder(this.infoPanel_);
        this.ctrl_.process(this.infoPanel_);
        for (int row = 0; row < 16; ++row) {
            this.lblStatic_[row] = new JLabel();
            this.ctrl_.process(this.lblStatic_[row]);
            this.txtValues_[row] = new JTextField();
            this.txtValues_[row].setEditable(false);
            this.txtValues_[row].setBackground(this.ctrl_.getUneditColumnBackground());
            GuiHelper.addGridbagPair(this.lblStatic_[row], this.txtValues_[row], gbc, this.infoPanel_, row);
        }
    }

    private JPanel getSouthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JSeparator());
        panel.add(this.btnPanel_);
        return panel;
    }

    private void buildBtnPanel() {
        this.btnPanel_ = new JPanel();
        this.btnPanel_.setLayout(new BoxLayout(this.btnPanel_, 0));
        this.btnPanel_.add(Box.createGlue());
        this.btnPanel_.add(this.btnRefresh_);
        this.btnPanel_.add(Box.createHorizontalStrut(5));
        this.btnPanel_.add(this.btnClose_);
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.btnPanel_.setBorder(border);
    }

    private void addListeners() {
        this.lisRefresh_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuntimeInfoPanel.this.refresh();
            }
        };
        this.lisClose_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (RuntimeInfoPanel.this.parentContainer_ != null) {
                    GuiHelper.closeParent(RuntimeInfoPanel.this.parentContainer_);
                }
            }
        };
        this.btnRefresh_.addActionListener(this.lisRefresh_);
        this.btnClose_.addActionListener(this.lisClose_);
    }

    private void addParentListeners() {
        if (this.parentContainer_ != null) {
            GuiHelper.addContainerCancelAction(this.parentContainer_);
        }
    }

    private void setNames() {
        this.setName(TITLE);
        this.btnRefresh_.setName("btnRefresh");
        this.btnClose_.setName("btnClose");
    }

    private void setCosmetics() {
        this.btnRefresh_.setMnemonic('R');
        this.btnClose_.setMnemonic('C');
    }

    public void refresh() {
        String bytesStr = " " + FileHelper.getRes("memory.bytes.msg");
        String mbAbbr = " " + ResMgr.getRes("memory.bytes.mega.abbr");
        int row = -1;
        this.refreshSubTitlePair(++row, "application.label");
        this.lblStatic_[++row].setText(this.spacing_ + this.appName_ + " " + FileHelper.getRes("version.label") + ": ");
        this.txtValues_[row].setText(this.appVersion_);
        this.refreshLabelPair(++row, "user.name.label", "user.name");
        this.refreshSubTitlePair(++row, "java.vm.label");
        this.refreshLabelPair(++row, "java.version.label", "java.version");
        this.refreshLabelPair(++row, "java.home.label", "java.home");
        this.refreshLabelPair(++row, "java.class.version.label", "java.class.version");
        this.refreshSubTitlePair(++row, "os.label");
        this.refreshLabelPair(++row, "os.name.label", "os.name");
        this.refreshLabelPair(++row, "os.arch.label", "os.arch");
        this.refreshLabelPair(++row, "os.version.label", "os.version");
        this.refreshSubTitlePair(++row, "memory.label");
        this.lblStatic_[++row].setText(this.spacing_ + ResMgr.getRes("memory.used.label") + ": ");
        this.txtValues_[row].setText(this.getMegaBytesFormatted(this.runtime_.totalMemory() - this.runtime_.freeMemory()) + mbAbbr);
        this.lblStatic_[++row].setText(this.spacing_ + ResMgr.getRes("memory.free.label") + ": ");
        this.txtValues_[row].setText(this.getMegaBytesFormatted(this.runtime_.freeMemory()) + mbAbbr);
        this.lblStatic_[++row].setText(this.spacing_ + ResMgr.getRes("memory.total.label") + ": ");
        this.txtValues_[row].setText(this.getMegaBytesFormatted(this.runtime_.totalMemory()) + mbAbbr);
        this.lblStatic_[++row].setText(this.spacing_ + ResMgr.getRes("memory.max.label") + ": ");
        this.txtValues_[row].setText(this.getMegaBytesFormatted(this.runtime_.maxMemory()) + mbAbbr);
    }

    private String getMegaBytesFormatted(long bytes) {
        return StrHelper.getMegaBytesFormatted(bytes);
    }

    private void refreshSubTitlePair(int labelRow, String resource) {
        Font font = this.lblStatic_[labelRow].getFont();
        font = new Font(font.getName(), font.getStyle(), font.getSize());
        this.lblStatic_[labelRow].setFont(font);
        Color color = Colors.getBlueKeyword();
        this.lblStatic_[labelRow].setForeground(color);
        this.lblStatic_[labelRow].setHorizontalAlignment(2);
        this.lblStatic_[labelRow].setText(FileHelper.getRes(resource));
        this.txtValues_[labelRow].setVisible(false);
    }

    private void refreshLabelPair(int labelRow, String resource, String property) {
        String dynamicInfo = "";
        try {
            dynamicInfo = System.getProperty(property);
        }
        catch (Exception e) {
            dynamicInfo = e.getMessage();
            LogUtil.logErr(e.getMessage());
        }
        this.lblStatic_[labelRow].setText(this.spacing_ + FileHelper.getRes(resource) + ": ");
        this.txtValues_[labelRow].setText(dynamicInfo);
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(375, 520);
    }

    private void checkInputs(String appName, String appVersion) {
        if (appName == null) {
            StrHelper.throwProgrammingException("RuntimeInfoPanel - appName can not be null.");
        }
        if (appVersion == null) {
            StrHelper.throwProgrammingException("RuntimeInfoPanel - appVersion can not be null.");
        }
    }

    @Override
    public void setParentContainer(RootPaneContainer parentContainer) {
        this.parentContainer_ = parentContainer;
        this.addParentListeners();
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.QUESTION;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getToolTip() {
        return this.getTitle();
    }
}

