/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.panel;

import com.harrand.coreclasses.display.Colors;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    private Color startColor_;
    private Color endColor_;
    private Font font_;
    private int textWidth_;
    private int textHeight_;
    private String text_ = "Gradient Panel";
    public static final int LEFT_PAD = 3;
    public static final int RIGHT_PAD = 1;
    public static final int TOP_PAD = 2;
    public static final int BOTTOM_PAD = 2;

    public GradientPanel(Color startColor, Color endColor, int fontSz, String text) {
        this.startColor_ = startColor;
        this.endColor_ = endColor;
        this.font_ = new Font("Verdana", 1, fontSz);
        this.setText(text);
    }

    public void setText(String text) {
        this.text_ = text;
        this.updateMetrics();
        this.refresh();
    }

    private void refresh() {
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawGoogleBand(g2);
    }

    private void drawGoogleBand(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(Colors.getGrayUltraLight());
        g2.fill(new Rectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1));
        g2.setFont(this.font_);
        g2.setPaint(Color.BLACK);
        int yStart = this.font_.getSize() + 2;
        g2.drawString(this.text_, 3, yStart);
        this.drawBottomLine(g2);
    }

    private void drawGradient150(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        GradientPaint gradient = new GradientPaint(0.0f, 0.0f, this.startColor_, this.getWidth(), 0.0f, this.endColor_);
        g2.setPaint(gradient);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, this.getWidth() - 1, this.getHeight() - 1));
        g2.setFont(this.font_);
        g2.setPaint(Color.WHITE);
        int yStart = this.font_.getSize() + 2;
        g2.drawString(this.text_, 3, yStart);
        this.drawBottomLine(g2);
    }

    private void drawBottomLine(Graphics2D g2) {
        int y = this.getHeight() - 1;
        int endX = this.getWidth() - 1;
        g2.setPaint(Colors.getBlueMild());
        g2.drawLine(0, y, endX, y);
    }

    private void updateMetrics() {
        FontMetrics metrics = this.getFontMetrics(this.font_);
        this.textWidth_ = metrics.stringWidth(this.text_);
        this.textHeight_ = metrics.getHeight();
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = new Dimension(this.textWidth_ + 3 + 1, this.textHeight_ + 2 + 2);
        return dim;
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }
}

