/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.naming;

import com.harrand.coreclasses.naming.INameProps;
import com.harrand.coreclasses.naming.NameProps;
import com.harrand.coreclasses.notification.BasicObservable;
import com.harrand.coreclasses.notification.IObservable;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class SuffixPrefixPanel
extends JPanel
implements IObservable {
    private INameProps props_ = null;
    private BasicObservable observable_ = new BasicObservable();
    private JTextField txtSuffix_ = new JTextField(5);
    private JTextField txtSeparator_ = new JTextField(2);
    private JTextField txtPrefix_ = new JTextField(5);
    private JLabel lblPrefix_;
    private JLabel lblSeparator_;
    private JLabel lblSuffix_;
    private SwingThemeCtrl themeCtrl_;

    public SuffixPrefixPanel(INameProps props) {
        this.props_ = props;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
        this.loadData();
    }

    private void setupGui() {
        this.buildControls();
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void buildControls() {
        String div = "";
        this.lblPrefix_ = new JLabel("Prefix" + div);
        this.lblSeparator_ = new JLabel("Separator" + div);
        this.lblSuffix_ = new JLabel("Suffix" + div);
    }

    private void setCosmetics() {
    }

    private void loadData() {
        if (this.props_ != null) {
            this.txtPrefix_.setText(this.props_.getPrefix());
            this.txtSeparator_.setText(this.props_.getSeparator());
            this.txtSuffix_.setText(this.props_.getSuffix());
        } else {
            this.txtPrefix_.setText("");
            this.txtSeparator_.setText("");
            this.txtSuffix_.setText("");
        }
    }

    private void layoutComponents() {
        JPanel northPanel = this.getNorthPanel();
        this.themeCtrl_.process(northPanel);
        this.setLayout(new BorderLayout(0, 0));
        this.add((Component)northPanel, "North");
    }

    private JPanel getNorthPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPairFixed(this.lblPrefix_, this.txtPrefix_, gbc, panel, row++);
        GuiHelper.addGridbagPairFixed(this.lblSeparator_, this.txtSeparator_, gbc, panel, row++);
        GuiHelper.addGridbagPairFixed(this.lblSuffix_, this.txtSuffix_, gbc, panel, row++);
        return panel;
    }

    private void setNames() {
        this.lblPrefix_.setName("lblPrefix");
        this.txtPrefix_.setName("txtPrefix");
        this.txtSeparator_.setName("txtSeparator");
        this.lblSuffix_.setName("lblSuffix");
        this.txtSuffix_.setName("txtSuffix");
    }

    private void addListeners() {
        this.addListenersGetFocus();
        this.addKeyListeners();
    }

    private void addListenersGetFocus() {
        this.txtPrefix_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SuffixPrefixPanel.this.txtPrefix_.selectAll();
            }
        });
        this.txtSeparator_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SuffixPrefixPanel.this.txtSeparator_.selectAll();
            }
        });
        this.txtSuffix_.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SuffixPrefixPanel.this.txtSuffix_.selectAll();
            }
        });
    }

    private void addKeyListeners() {
        KeyListener lisTyped = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                SuffixPrefixPanel.this.syncData();
                SuffixPrefixPanel.this.notifyObservers(new UpdateChain(SuffixPrefixPanel.this.props_));
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        };
        this.txtPrefix_.addKeyListener(lisTyped);
        this.txtSeparator_.addKeyListener(lisTyped);
        this.txtSuffix_.addKeyListener(lisTyped);
    }

    public INameProps getNameProps() {
        this.syncData();
        return this.props_;
    }

    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 50, 350, 160);
    }

    private void syncData() {
        String prefix = this.txtPrefix_.getText();
        String separator = this.txtSeparator_.getText();
        String suffix = this.txtSuffix_.getText();
        NameProps newNameProps = new NameProps(prefix, separator, suffix);
        this.props_ = newNameProps;
    }

    @Override
    public int getObserverCount() {
        return this.observable_.getObserverCount();
    }

    @Override
    public void removeAllObservers() {
        this.observable_.removeAllObservers();
    }

    @Override
    public void addObserver(IObserver observer) {
        this.observable_.addObserver(observer);
    }

    @Override
    public void notifyObservers(UpdateChain chain) {
        if (chain == null) {
            chain = new UpdateChain();
        }
        chain.add(this);
        this.observable_.notifyObservers(chain);
    }

    @Override
    public void removeObserver(IObserver observer) {
        this.observable_.removeObserver(observer);
    }
}

