/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.menu;

import java.io.File;
import javax.swing.JMenuItem;

public final class FileMenuItem
extends JMenuItem {
    private File file_;
    private int position_;

    public FileMenuItem(int position, File file) {
        this.position_ = position;
        this.setFile(file);
    }

    public void setFile(File file) {
        this.file_ = file;
        this.refresh();
    }

    public int getPosition() {
        return this.position_;
    }

    public File getFile() {
        return new File(this.file_.getPath());
    }

    private void refresh() {
        if (this.file_ != null) {
            this.refreshText();
            this.refreshMnemonic();
            this.refreshTooltip();
        } else {
            this.setText("");
            this.setToolTipText("");
        }
        this.setVisible(this.file_ != null);
    }

    private void refreshText() {
        String fileName = this.file_.getName();
        String sep = File.separator;
        if (sep.equals("\\")) {
            sep = "\\";
        }
        String[] pathParts = this.file_.getParent().split("\\\\");
        StringBuffer sb = new StringBuffer(this.position_ + ": ");
        if (pathParts.length > 1) {
            sb.append(pathParts[0] + sep + "..." + sep + pathParts[pathParts.length - 1] + sep + fileName);
        } else {
            sb.append(fileName);
        }
        this.setText(sb.toString());
    }

    private void refreshMnemonic() {
        this.setMnemonic(Integer.toString(this.position_).charAt(0));
    }

    private void refreshTooltip() {
        this.setToolTipText(this.file_.getPath());
    }
}

