/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.list;

import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;

public final class MultikeyComboSelectionManager
implements JComboBox.KeySelectionManager {
    private String searchStr_ = new String();
    private long lastTime_;
    private ComboBoxModel model_;

    public String getSearchString() {
        return this.searchStr_;
    }

    public int selectionForKey(char aKey, ComboBoxModel aModel) {
        this.model_ = aModel;
        this.updateSearchString(aKey);
        int start = this.findIndex(this.getSelectedString());
        int selection = this.search(start);
        if (selection == -1 && start != 0) {
            selection = this.search(0);
        }
        if (selection == -1) {
            selection = start;
        }
        return selection;
    }

    private int search(int start) {
        int searchLength = this.searchStr_.length();
        for (int i = 0; i < this.model_.getSize(); ++i) {
            String s = this.getString(i);
            if (!s.regionMatches(0, this.searchStr_, 0, searchLength)) continue;
            return i;
        }
        return -1;
    }

    private int findIndex(String find) {
        int size = this.model_.getSize();
        if (find != null) {
            for (int i = 0; i < size; ++i) {
                String s = this.getString(i);
                if (s.compareToIgnoreCase(find) != 0) continue;
                return i == size - 1 ? 0 : i + 1;
            }
        }
        return 0;
    }

    private String getString(int index) {
        Object obj = this.model_.getElementAt(index);
        return obj.toString().toLowerCase();
    }

    private String getSelectedString() {
        Object obj = this.model_.getSelectedItem();
        return obj.toString();
    }

    private void updateSearchString(char key) {
        long time = System.currentTimeMillis();
        this.searchStr_ = time - this.lastTime_ < 500L ? this.searchStr_ + key : "" + key;
        this.searchStr_ = this.searchStr_.toLowerCase();
        this.lastTime_ = time;
    }
}

