/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.list;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.interfaces.IIconable;
import com.harrand.coregui.Icons;
import com.harrand.util.LogUtil;
import java.awt.Component;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public final class IconListCellRenderer
extends JLabel
implements ListCellRenderer {
    public IconListCellRenderer() {
        this.setOpaque(true);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value instanceof IIconable) {
            URL url = ((IIconable)value).getIconUrl();
            if (url != null) {
                this.setIcon(new ImageIcon(url));
            } else {
                LogUtil.logErr(this, "'url' is null for 'value': " + value.toString());
                this.setIcon(Icons.NULL_ICON);
            }
        } else {
            this.setIcon(Icons.NULL_ICON);
        }
        if (value != null) {
            this.setText(value.toString());
        } else {
            this.setText("");
        }
        if (isSelected) {
            this.setForeground(list.getSelectionForeground());
            this.setBackground(Colors.getBlueMild());
        } else {
            this.setForeground(list.getForeground());
            this.setBackground(Colors.getYellowSoft());
        }
        return this;
    }
}

