/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.list;

import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataListener;

public final class DualListPanel
extends JPanel {
    private Object[] leftItems;
    private Object[] rightItems;
    private JPanel leftPanel = new JPanel();
    private JPanel buttonPanel_ = new JPanel();
    private JPanel rightPanel = new JPanel();
    private JButton btnToLeft = new JButton("<");
    private JButton btnToRight = new JButton(">");
    private JButton btnAllLeft = new JButton("<<");
    private JButton btnAllRight = new JButton(">>");
    private JList lstLeft = new JList();
    private JList lstRight = new JList();
    private DefaultListModel modelLeft = new DefaultListModel();
    private DefaultListModel modelRight = new DefaultListModel();
    private JLabel lblLeft_;
    private JLabel lblRight_;
    private SwingThemeCtrl themeCtrl_;
    private MouseListener toLeftMouseLis_;
    private MouseListener toRightMouseLis_;
    public static final int LEFT_ID = 0;
    public static final int RIGHT_ID = 1;
    private ListCellRenderer listCellRenderer;

    public DualListPanel(Object[] theLeftItems, Object[] theRightItems) throws IllegalArgumentException {
        this.init(theLeftItems, theRightItems, null);
    }

    public DualListPanel(Object[] theLeftItems, Object[] theRightItems, ListCellRenderer listCellRenderer) throws IllegalArgumentException {
        this.init(theLeftItems, theRightItems, listCellRenderer);
    }

    private void init(Object[] theLeftItems, Object[] theRightItems, ListCellRenderer listCellRenderer) {
        this.initComponents();
        this.leftItems = theLeftItems;
        this.rightItems = theRightItems;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.listCellRenderer = listCellRenderer;
        if (listCellRenderer != null) {
            this.lstLeft.setCellRenderer(listCellRenderer);
            this.lstRight.setCellRenderer(listCellRenderer);
        }
        this.addPanels();
        this.setNames();
        this.setModels();
        this.refreshData();
        this.setCosmetics();
        this.addListeners();
    }

    private void setModels() {
        this.lstLeft.setModel(this.modelLeft);
        this.lstRight.setModel(this.modelRight);
    }

    private void refreshData() {
        int i;
        this.modelLeft.removeAllElements();
        for (i = 0; i < this.leftItems.length; ++i) {
            this.modelLeft.addElement(this.leftItems[i]);
        }
        this.modelRight.removeAllElements();
        for (i = 0; i < this.rightItems.length; ++i) {
            this.modelRight.addElement(this.rightItems[i]);
        }
    }

    private void addPanels() {
        this.setLayout(new GridLayout(1, 3, 4, 4));
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        GuiHelper.buildGridBagConstraints(gbc, 0, 0, 1, 1, 90.0, 100.0);
        gbc.fill = 1;
        this.leftPanel.setLayout(new BorderLayout());
        this.lblLeft_ = new JLabel("Left");
        Font defaultFont = this.lblLeft_.getFont();
        Font boldFont = new Font(defaultFont.getName(), 1, defaultFont.getSize());
        this.lblLeft_.setFont(boldFont);
        this.leftPanel.add((Component)this.lblLeft_, "North");
        this.leftPanel.add((Component)new JScrollPane(this.lstLeft), "Center");
        this.add((Component)this.leftPanel, gbc);
        this.buildButtonPanel();
        GuiHelper.buildGridBagConstraints(gbc, 1, 0, 1, 1, 10.0, 100.0);
        gbc.fill = 3;
        this.add((Component)this.buttonPanel_, gbc);
        this.rightPanel.setLayout(new BorderLayout());
        this.lblRight_ = new JLabel("Right");
        this.lblRight_.setFont(boldFont);
        this.rightPanel.add((Component)this.lblRight_, "North");
        this.rightPanel.add((Component)new JScrollPane(this.lstRight), "Center");
        GuiHelper.buildGridBagConstraints(gbc, 2, 0, 1, 1, 90.0, 100.0);
        gbc.fill = 1;
        this.add((Component)this.rightPanel, gbc);
    }

    private void buildButtonPanel() {
        this.buttonPanel_.setLayout(new BoxLayout(this.buttonPanel_, 1));
        this.buttonPanel_.add(Box.createGlue());
        this.buttonPanel_.add(this.btnToLeft);
        this.buttonPanel_.add(Box.createVerticalStrut(5));
        this.buttonPanel_.add(this.btnToRight);
        this.buttonPanel_.add(Box.createGlue());
        this.buttonPanel_.add(new JLabel());
        this.themeCtrl_.process(this.buttonPanel_);
        this.themeCtrl_.process(this.btnToLeft);
        this.themeCtrl_.process(this.btnToRight);
        this.themeCtrl_.process(this.btnAllLeft);
        this.themeCtrl_.process(this.btnAllRight);
    }

    private void setNames() {
        this.leftPanel.setName("leftPanel");
        this.buttonPanel_.setName("buttonPanel");
        this.rightPanel.setName("rightPanel");
        this.lstLeft.setName("lstLeft");
        this.lstRight.setName("lstRight");
        this.btnToLeft.setName("btnToLeft");
        this.btnToRight.setName("btnToRight");
        this.btnAllLeft.setName("btnAllLeft");
        this.btnAllRight.setName("btnAllRight");
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.themeCtrl_.process(this.lstLeft);
        this.themeCtrl_.process(this.lstRight);
        this.btnToLeft.setMnemonic('A');
        this.btnToLeft.setToolTipText("Alt+A");
        this.btnToRight.setMnemonic('B');
        this.btnToRight.setToolTipText("Alt+B");
        this.btnToLeft.setMaximumSize(this.btnToLeft.getPreferredSize());
        this.btnToRight.setMaximumSize(this.btnToRight.getPreferredSize());
    }

    public void setLeftLabel(String text) {
        this.lblLeft_.setText(text);
    }

    public void setRightLabel(String text) {
        this.lblRight_.setText(text);
    }

    public void setData(Object[] theLeftItems, Object[] theRightItems) {
        this.leftItems = theLeftItems;
        this.rightItems = theRightItems;
        this.refreshData();
    }

    public void addToLeftListener(ActionListener lis) {
        this.btnToLeft.addActionListener(lis);
    }

    public void addToRightListener(ActionListener lis) {
        this.btnToRight.addActionListener(lis);
    }

    public void addToLeftMouseListener(MouseListener lis) {
        this.lstRight.removeMouseListener(this.toLeftMouseLis_);
        this.lstRight.addMouseListener(lis);
    }

    public void addToRightMouseListener(MouseListener lis) {
        this.lstLeft.removeMouseListener(this.toRightMouseLis_);
        this.lstLeft.addMouseListener(lis);
    }

    public void addListDataListener(ListDataListener lis) {
        this.modelLeft.addListDataListener(lis);
    }

    public void removeListDataListener(ListDataListener lis) {
        this.modelLeft.removeListDataListener(lis);
    }

    public Object[] getLeftItems() {
        int length = this.lstLeft.getModel().getSize();
        Object[] items = new Object[length];
        for (int i = 0; i < length; ++i) {
            items[i] = this.lstLeft.getModel().getElementAt(i);
        }
        return items;
    }

    public Object[] getRightItems() {
        int length = this.lstRight.getModel().getSize();
        Object[] items = new Object[length];
        for (int i = 0; i < length; ++i) {
            items[i] = this.lstRight.getModel().getElementAt(i);
        }
        return items;
    }

    public List getSelectedItems(int sideId) {
        JList list = sideId == 0 ? this.lstLeft : this.lstRight;
        DefaultListModel model = (DefaultListModel)list.getModel();
        int length = model.getSize();
        ArrayList selItems = new ArrayList();
        for (int i = 0; i < length; ++i) {
            if (!list.isSelectedIndex(i)) continue;
            selItems.add(model.getElementAt(i));
        }
        return selItems;
    }

    public void moveAll(JList source, JList dest) {
        source.setSelectionInterval(0, source.getModel().getSize() - 1);
        this.moveSelected(source, dest);
    }

    public void moveSelected(JList source, JList dest) {
        int i;
        DefaultListModel sourceModel = (DefaultListModel)source.getModel();
        DefaultListModel destModel = (DefaultListModel)dest.getModel();
        int len = sourceModel.getSize();
        for (i = 0; i < len; ++i) {
            if (!source.isSelectedIndex(i)) continue;
            destModel.addElement(sourceModel.get(i));
        }
        for (i = len - 1; i >= 0; --i) {
            if (!source.isSelectedIndex(i)) continue;
            sourceModel.remove(i);
        }
    }

    public void moveLeft(String itemNm) {
        this.lstRight.setSelectedValue(itemNm, true);
        this.moveSelected(this.lstRight, this.lstLeft);
    }

    public void moveLeft(Object item) {
        this.lstRight.setSelectedValue(item, true);
        this.moveSelected(this.lstRight, this.lstLeft);
    }

    private void addListeners() {
        this.addButtonListeners();
        this.toLeftMouseLis_ = new LocalMouseListener(this.lstRight, this.lstLeft);
        this.toRightMouseLis_ = new LocalMouseListener(this.lstLeft, this.lstRight);
        this.lstRight.addMouseListener(this.toLeftMouseLis_);
        this.lstLeft.addMouseListener(this.toRightMouseLis_);
    }

    private void addButtonListeners() {
        this.btnToLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DualListPanel.this.moveSelected(DualListPanel.this.lstRight, DualListPanel.this.lstLeft);
            }
        });
        this.btnToRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DualListPanel.this.moveSelected(DualListPanel.this.lstLeft, DualListPanel.this.lstRight);
            }
        });
        this.btnAllLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DualListPanel.this.moveAll(DualListPanel.this.lstRight, DualListPanel.this.lstLeft);
            }
        });
        this.btnAllRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DualListPanel.this.moveAll(DualListPanel.this.lstLeft, DualListPanel.this.lstRight);
            }
        });
    }

    public void addToLeftList(Object object) {
        DefaultListModel model = (DefaultListModel)this.lstLeft.getModel();
        model.addElement(object);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    private class LocalMouseListener
    extends MouseAdapter {
        private JList source_;
        private JList dest_;

        public LocalMouseListener(JList source, JList dest) {
            this.source_ = source;
            this.dest_ = dest;
        }

        @Override
        public void mouseClicked(MouseEvent evt) {
            if ((evt.getModifiers() & 0x10) != 0 && evt.getClickCount() == 2) {
                DualListPanel.this.moveSelected(this.source_, this.dest_);
            }
        }
    }
}

