/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.list;

import com.harrand.coregui.list.DNDComponentInterface;
import com.harrand.util.LogUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JViewport;

public class DNDList
extends JList
implements DNDComponentInterface,
DropTargetListener,
DragSourceListener,
DragGestureListener {
    private DefaultListModel model_ = new DefaultListModel();
    private DropTarget dropTarget = null;
    private DragSource dragSource = null;
    private JScrollPane scroll_ = null;

    public DNDList(List stringItems) {
        this.setModel(this.model_);
        this.setSelectionMode(1);
        Iterator it = stringItems.iterator();
        while (it.hasNext()) {
            this.model_.addElement((String)it.next());
        }
        this.dropTarget = new DropTarget(this, this);
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
    }

    public void setScrollPane(JScrollPane scroll) {
        this.scroll_ = scroll;
    }

    public JScrollPane getScrollPane() {
        return this.scroll_;
    }

    private void processDrop(DropTargetDropEvent event) {
        int insertIdx;
        if (this.model_.size() < 2) {
            return;
        }
        int idx = this.locationToIndex(event.getLocation());
        String droppedOnStr = this.model_.getElementAt(idx).toString();
        boolean bottomHalf = this.getDroppedBottomHalf(event);
        Object[] selectedObjs = this.getSelectedValues();
        int[] selectedIdxs = this.getSelectedIndices();
        for (int i = selectedIdxs.length - 1; i >= 0; --i) {
            this.model_.remove(selectedIdxs[i]);
        }
        int n = insertIdx = this.model_.contains(droppedOnStr) ? this.model_.indexOf(droppedOnStr) : this.model_.size() - 1;
        if (bottomHalf) {
            ++insertIdx;
        }
        for (int i = selectedIdxs.length - 1; i >= 0; --i) {
            this.model_.add(insertIdx, selectedObjs[i]);
        }
    }

    private boolean getDroppedBottomHalf(DropTargetDropEvent event) {
        boolean isBottomHalf = false;
        if (this.model_.size() > 1) {
            int halfHeight;
            Point pt0 = this.indexToLocation(0);
            Point pt1 = this.indexToLocation(1);
            int elementHeight = (int)(pt1.getY() - pt0.getY());
            Point dropPt = event.getLocation();
            int dropIdx = this.locationToIndex(dropPt);
            int extra = (int)(dropPt.getY() - (double)(dropIdx * elementHeight));
            if (extra > (halfHeight = (int)(0.5 * (double)elementHeight))) {
                isBottomHalf = true;
            }
        }
        return isBottomHalf;
    }

    public void autoScroll(boolean dragUp) {
        if (this.scroll_ != null) {
            int increment = 6;
            JViewport vp = this.scroll_.getViewport();
            Rectangle vpBounds = vp.getBounds();
            int scrHeight = (int)this.scroll_.getBounds().getHeight();
            int listHeight = (int)this.getBounds().getHeight();
            Point viewPos = vp.getViewPosition();
            if (!dragUp) {
                int maxY = listHeight - scrHeight;
                viewPos.y += increment;
                if (viewPos.y > maxY) {
                    viewPos.y = maxY;
                }
                vp.setViewPosition(viewPos);
            } else {
                viewPos.y -= increment;
                if (viewPos.y < 0) {
                    viewPos.y = 0;
                }
                vp.setViewPosition(viewPos);
            }
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent event) {
    }

    @Override
    public void dragExit(DropTargetEvent event) {
    }

    @Override
    public void dragOver(DropTargetDragEvent event) {
    }

    @Override
    public void drop(DropTargetDropEvent event) {
        try {
            Transferable transferable = event.getTransferable();
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                event.acceptDrop(2);
                String s = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                this.processDrop(event);
                event.getDropTargetContext().dropComplete(true);
            } else {
                event.rejectDrop();
            }
        }
        catch (IOException exception) {
            LogUtil.logErr("DNDList.IOException: " + exception.getMessage());
            event.rejectDrop();
        }
        catch (UnsupportedFlavorException ufException) {
            LogUtil.logErr("DNDList.ufException: " + ufException.getMessage());
            event.rejectDrop();
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent event) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent event) {
        Object selected = this.getSelectedValue();
        if (selected != null) {
            StringSelection text = new StringSelection(selected.toString());
            this.dragSource.startDrag(event, DragSource.DefaultMoveDrop, text, this);
        } else {
            LogUtil.logErr("DndList.nothing was selected");
        }
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent event) {
        if (event.getDropSuccess()) {
            // empty if block
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent event) {
    }

    @Override
    public void dragExit(DragSourceEvent e) {
    }

    @Override
    public void dragOver(DragSourceDragEvent event) {
        int idx = this.locationToIndex(event.getLocation());
        Point pt = this.indexToLocation(idx);
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent event) {
    }

    @Override
    public void addElement(Object s) {
        this.model_.addElement(s.toString());
    }

    @Override
    public void removeElement() {
        this.model_.removeElement(this.getSelectedValue());
    }
}

