/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.label;

import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;

public final class StatusLabel
extends JLabel {
    private int proportion_;
    private SwingThemeCtrl themeCtrl_;
    private ImageIcon icon_;
    private Color foreColor_;
    private static final Color BUSY_COLOR = Color.BLACK;

    public StatusLabel(int proportion, String text, ImageIcon icon) {
        super(text);
        this.proportion_ = proportion;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.icon_ = icon;
        if (this.icon_ == null) {
            this.icon_ = Icons.VERT_STRIP;
        }
        this.foreColor_ = this.getForeground();
        this.setCosmetics();
        this.setIcon(this.icon_);
    }

    private void setCosmetics() {
    }

    private void setDefaultBorder() {
        MatteBorder topBdr = BorderFactory.createMatteBorder(4, 0, 0, 0, Icons.STATUS_BORDER_TOP);
        MatteBorder btmBdr = BorderFactory.createMatteBorder(0, 0, 4, 0, Icons.STATUS_BORDER_BTM);
        CompoundBorder compBdr = BorderFactory.createCompoundBorder(topBdr, btmBdr);
        this.setBorder(compBdr);
    }

    public int getProportion() {
        return this.proportion_;
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        if (text.indexOf("...") >= 0) {
            this.setForeground(BUSY_COLOR);
        } else {
            this.setForeground(this.foreColor_);
        }
    }
}

