/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.helper;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.system.JvmUtil;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.dialog.CancelAction;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.listener.BasicFocusListener;
import com.harrand.coregui.table.TableModelBasic;
import com.harrand.util.LogUtil;
import com.harrand.util.ResMgr;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.Stroke;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public final class GuiHelper {
    private static final JPanel panel__ = new JPanel();
    private static FontMetrics fontMetrics__;
    public static final String BTN_CLOSE_NM = "btnClose";
    public static final int EMPTY_BORDER_THICK = 5;
    public static final double TEXT_LINE_VERT_MARGIN_RATE = 1.2;
    public static final int INSET_DEFAULT = 2;
    public static final int TABLE_COLUMN_PAD = 25;
    public static final String EVENT_SOURCE = "From GuiHelper";
    private static final Border emptyBorder__;
    private static final Border smallBorder__;
    private static final String NULL_STR_UC;
    private static DefaultTableModel blankTableModel__;
    public static final Cursor BUSY_CURSOR;
    public static final Cursor DEFAULT_CURSOR;
    public static final Cursor HAND_CURSOR;
    public static final Cursor CURSOR_MOVE;
    public static final Cursor CURSOR_NW_RESIZE;
    public static final Cursor CURSOR_N_RESIZE;
    public static final Cursor CURSOR_NE_RESIZE;
    public static final Cursor CURSOR_E_RESIZE;
    public static final Cursor CURSOR_SE_RESIZE;
    public static final Cursor CURSOR_S_RESIZE;
    public static final Cursor CURSOR_SW_RESIZE;
    public static final Cursor CURSOR_W_RESIZE;
    public static Cursor closeHandCursor__;
    public static Cursor openHandCursor__;

    public static void buildGridBagConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
        gbc.insets = new Insets(2, 2, 2, 2);
    }

    public static void addGridbagPair(JComponent firstItem, JComponent secondItem, GridBagConstraints gbc, JPanel panel, int row) {
        int firstAnchor = secondItem instanceof JScrollPane ? 18 : 17;
        GuiHelper.buildGridBagConstraints(gbc, 0, row, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = firstAnchor;
        panel.add((Component)firstItem, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row, 1, 1, 90.0, 0.0);
        gbc.fill = 2;
        gbc.anchor = 17;
        panel.add((Component)secondItem, gbc);
    }

    public static void addGridbagPairFixed(JComponent firstItem, JComponent secondItem, GridBagConstraints gbc, JPanel panel, int row) {
        GuiHelper.buildGridBagConstraints(gbc, 0, row, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)firstItem, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row, 1, 1, 90.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)secondItem, gbc);
    }

    public static void addGridbagPairPadded(JComponent firstItem, JComponent secondItem, GridBagConstraints gbc, JPanel panel, int row) {
        GuiHelper.buildGridBagConstraints(gbc, 0, row, 1, 1, 10.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)firstItem, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 1, row, 1, 1, 50.0, 0.0);
        gbc.fill = 2;
        gbc.anchor = 17;
        panel.add((Component)secondItem, gbc);
        GuiHelper.buildGridBagConstraints(gbc, 2, row, 1, 1, 40.0, 0.0);
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)new JLabel(), gbc);
    }

    public static JPanel getTriItemPanel(JComponent itemA, JComponent itemB, JComponent itemC) {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 5, 5, 0));
        panel.add(itemA);
        panel.add(itemB);
        panel.add(itemC);
        panel.add(new JLabel());
        return panel;
    }

    public static JPanel getBorderLayoutPanel() {
        JPanel panel = new JPanel(new BorderLayout(4, 4));
        return panel;
    }

    public static JPanel getRightGluedPanel(JComponent comp) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(comp);
        panel.add(Box.createGlue());
        return panel;
    }

    public static void setWidthRestrictions(JComponent comp) {
        comp.setMaximumSize(new Dimension(100, 1000));
        comp.setPreferredSize(new Dimension(100, 1000));
    }

    public static JPanel getOneThirdPanel(JComponent comp) {
        JPanel panel = new JPanel(new GridLayout(1, 3));
        panel.add(comp);
        panel.add(new JLabel());
        panel.add(new JLabel());
        return panel;
    }

    public static JLabel getTitleLabel(String title) {
        JLabel lblTitle = new JLabel(title);
        String defFontNm = lblTitle.getFont().getName();
        int defFontSz = lblTitle.getFont().getSize();
        lblTitle.setForeground(Colors.getBlueXpTitle());
        lblTitle.setFont(new Font(defFontNm, 1, defFontSz));
        return lblTitle;
    }

    public static void setBoldFont(JLabel lbl) {
        Font oldFont = lbl.getFont();
        lbl.setFont(new Font(oldFont.getFontName(), 1, oldFont.getSize()));
    }

    public static int getFontLineHeight(Font font) {
        int vertStep = (int)(1.2 * (double)font.getSize());
        return vertStep;
    }

    public static int getVertTextMargin(int lineHeight) {
        double rate = 0.09999999999999998;
        double dblValue = (double)lineHeight * rate;
        int vertMargin = (int)Math.round(dblValue);
        return vertMargin;
    }

    public static Border getEmptyBorder() {
        return emptyBorder__;
    }

    public static void setTitledBorderBuffered(JComponent comp, String title) {
        Border emptyBorder = BorderFactory.createEmptyBorder(2, 5, 5, 5);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(title);
        CompoundBorder compBorder = BorderFactory.createCompoundBorder(titledBorder, emptyBorder);
        comp.setBorder(compBorder);
    }

    public static void centerWindow(JWindow window, Dimension dimension) {
        Dimension screenSize = window.getToolkit().getScreenSize();
        double startX = screenSize.getWidth() / 2.0 - dimension.getWidth() / 2.0;
        double startY = screenSize.getHeight() / 2.0 - dimension.getHeight() / 2.0;
        window.setLocation((int)startX, (int)startY);
    }

    public static void scrollUpInvokeLater(final JScrollPane scroll) {
        Runnable setVBar = new Runnable(){

            @Override
            public void run() {
                JScrollBar vbar = scroll.getVerticalScrollBar();
                vbar.setValue(0);
            }
        };
        SwingUtilities.invokeLater(setVBar);
    }

    public static void locateDialog(JDialog dlg, Rectangle bounds) {
        Rectangle2D parentBounds;
        Frame frame = ParentFrameSvr.instance().getParentFrame();
        if (frame != null) {
            parentBounds = frame.getBounds();
        } else {
            Dimension screenSize = dlg.getToolkit().getScreenSize();
            parentBounds = new Rectangle2D.Double(0.0, 0.0, screenSize.getWidth(), screenSize.getHeight());
        }
        double startX = parentBounds.getX() + parentBounds.getWidth() / 2.0 - bounds.getWidth() / 2.0;
        double startY = parentBounds.getY() + parentBounds.getHeight() / 2.0 - bounds.getHeight() / 2.0;
        dlg.setLocation((int)startX, (int)startY);
        dlg.setSize(bounds.getSize());
    }

    public static void delayRobot(int milliSec) {
        try {
            Robot robot = new Robot();
            robot.delay(milliSec);
        }
        catch (Exception e) {
            LogUtil.logErr("GuiHelper.delayRobot.err: " + e.getMessage());
        }
    }

    public static void setIcon(JDialog dlg, ImageIcon icon) {
        Frame f = JOptionPane.getFrameForComponent(dlg);
        if (icon != null) {
            if (f != null) {
                f.setIconImage(icon.getImage());
            }
        } else {
            StrHelper.throwProgExcept("icon can not be null.");
        }
    }

    public static JPanel getIconSidePanel(Icon icon) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 3));
        panel.add(Box.createVerticalStrut(10));
        panel.add(new JLabel(icon));
        int pad = 4;
        Border border = BorderFactory.createEmptyBorder(pad, 0, pad, 3 * pad);
        panel.setBorder(border);
        return panel;
    }

    public static JPanel getLeftAlignedPanel(JComponent comp) {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(comp);
        panel.add(Box.createHorizontalGlue());
        return panel;
    }

    public static void addFocusListener(JTextField txtField) {
        txtField.addFocusListener(new BasicFocusListener(txtField));
    }

    public static JInternalFrame getFrame(JDesktopPane desktopPane, String title) {
        JInternalFrame frmFound = null;
        JInternalFrame[] frames = desktopPane.getAllFrames();
        for (int i = 0; i < frames.length; ++i) {
            JInternalFrame frame = frames[i];
            if (!title.equals(frame.getTitle())) continue;
            frmFound = frame;
        }
        return frmFound;
    }

    public static JDialog createDialog(String title, boolean modal, JPanel mainPanel) {
        JDialog dlg = new JDialog(ParentFrameSvr.instance().getParentFrame());
        dlg.setModal(modal);
        dlg.setTitle(title);
        dlg.getContentPane().add(mainPanel);
        return dlg;
    }

    public static void addContainerCancelAction(RootPaneContainer container) {
        if (container != null) {
            KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
            container.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
            container.getRootPane().getActionMap().put("ESCAPE", new CancelAction(container));
        } else {
            System.out.println("GuiHelper.addContainerCancelAction: container is NULL");
        }
    }

    public static void closeDlg(JDialog dlg) {
        String javaStr = JvmUtil.getVersionStr();
        boolean isJava17 = JvmUtil.isJava17(javaStr);
        dlg.setVisible(false);
        dlg.dispose();
        dlg = null;
    }

    public static void closeParent(RootPaneContainer parent) {
        if (parent instanceof JDialog) {
            GuiHelper.closeDlg((JDialog)parent);
        }
        if (parent instanceof JInternalFrame) {
            try {
                ((JInternalFrame)parent).setClosed(true);
            }
            catch (Exception e) {
                System.out.println("GuiHelper.closeParent err: " + e.getMessage());
            }
        }
    }

    public static String getClipboardContents() {
        boolean hasTransferableText;
        String result = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(null);
        boolean bl = hasTransferableText = contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor);
        if (hasTransferableText) {
            try {
                result = (String)contents.getTransferData(DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException ex) {
                System.out.println(ex);
            }
            catch (IOException ex) {
                System.out.println(ex);
            }
        }
        return result;
    }

    public static void addOutlineBorder(JComponent comp) {
        comp.setBorder(BorderFactory.createLineBorder(Color.BLACK));
    }

    public static void addBodyPanelBorder(JPanel panel) {
        panel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
    }

    public static void addReducedBodyPanelBorder(JPanel panel) {
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
    }

    public static void addEmptyBorder(JComponent comp) {
        int th = 5;
        comp.setBorder(BorderFactory.createEmptyBorder(th, th, th, th));
    }

    public static void addSmallBorder(JPanel panel) {
        panel.setBorder(smallBorder__);
    }

    public static void addMedBorder(JPanel panel) {
        int th = 10;
        panel.setBorder(BorderFactory.createEmptyBorder(th, th, th, th));
    }

    public static void addTopBottomBorder(JPanel panel) {
        int th = 5;
        panel.setBorder(BorderFactory.createEmptyBorder(th, 0, th, 0));
    }

    public static void addTitledEmptyBorder(JComponent comp, String title) {
        int th = 5;
        Border emptyBorder = BorderFactory.createEmptyBorder(0, th, th, th);
        TitledBorder titleBorder = BorderFactory.createTitledBorder(title);
        CompoundBorder compoundBorder = new CompoundBorder(titleBorder, emptyBorder);
        comp.setBorder(compoundBorder);
    }

    public static int getColumnIndex(JTable table, String columnIdentifier) {
        int index = -1;
        try {
            index = table.getColumnModel().getColumnIndex(columnIdentifier);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return index;
    }

    public static int getTableModelColIdx(DefaultTableModel model, String colHeaderText) {
        int index = -1;
        index = model.findColumn(colHeaderText);
        return index;
    }

    public static int getColumnIndexInsensitive(JTable table, String findStr) {
        int index = -1;
        JTableHeader header = table.getTableHeader();
        TableColumnModel columnModel = table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            TableColumn column = columnModel.getColumn(i);
            String headerStr = column.getHeaderValue().toString();
            if (!findStr.equalsIgnoreCase(headerStr)) continue;
            index = i;
        }
        return index;
    }

    public static void optimizeTableColumnWidths(JTable table, int maxColWidth) {
        int rowCount = table.getRowCount();
        int colCount = table.getColumnCount();
        int[] colPixels_ = new int[colCount];
        Font font = table.getFont();
        for (int col = 0; col < colCount; ++col) {
            TableColumn tableColumn = table.getColumnModel().getColumn(col);
            String headerValue = tableColumn.getHeaderValue().toString();
            colPixels_[col] = GuiHelper.getSwingStringLength(headerValue, font) + 25;
            for (int row = 0; row < rowCount; ++row) {
                Object obj = table.getValueAt(row, col);
                if (obj == null) continue;
                String str = obj.toString();
                int currentPixels = GuiHelper.getSwingStringLength(str, font) + 25;
                colPixels_[col] = Math.max(colPixels_[col], currentPixels);
            }
            int colWidth = Math.min(colPixels_[col], maxColWidth);
            tableColumn.setPreferredWidth(colWidth);
        }
    }

    public static void hideColumn(JTable table, String columnName) {
        if (table != null) {
            try {
                TableColumn colHide = table.getColumn(columnName);
                colHide.setMaxWidth(0);
                colHide.setMinWidth(0);
                colHide.setWidth(0);
                colHide.setPreferredWidth(0);
            }
            catch (Exception e) {
                GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
            }
        }
    }

    public static int getColumnHeaderWidth(JTable table, TableColumn col) {
        TableCellRenderer renderer = table.getCellRenderer(0, col.getModelIndex());
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, col.getModelIndex());
        return comp.getPreferredSize().width;
    }

    public static int getColumnWidestCellWidth(JTable table, TableColumn col) {
        int c = col.getModelIndex();
        int width = 0;
        int maxw = 0;
        for (int r = 0; r < table.getRowCount(); ++r) {
            TableCellRenderer renderer = table.getCellRenderer(r, c);
            Component comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, c), false, false, r, c);
            width = comp.getPreferredSize().width;
            maxw = width > maxw ? width : maxw;
        }
        return maxw;
    }

    public static ArrayList getSelectedRowsToRemoveDisp(JTable table, String headerColumnName, String className) {
        ArrayList toRemove = new ArrayList();
        if (table.getSelectedRowCount() > 0) {
            String msg = GuiMessageHelper.getTableConfirmationMsg(table, className, headerColumnName);
            boolean result = GuiMessageHelper.showYesNoMsg(null, "Confirm Remove", msg);
            if (result) {
                toRemove = GuiHelper.getSelectedRowsToRemove(table, headerColumnName, className);
            }
        } else {
            GuiMessageHelper.showInputErrMsg(null, "Invalid Selection", "At least 1 table row must be selected.");
        }
        return toRemove;
    }

    private static ArrayList getSelectedRowsToRemove(JTable table, String headerColumnName, String className) {
        ArrayList<String> toRemove = new ArrayList<String>();
        int nameColumnIndex = table.getColumnModel().getColumnIndex(headerColumnName);
        for (int i = table.getRowCount(); i >= 0; --i) {
            if (!table.isRowSelected(i)) continue;
            String name = (String)table.getValueAt(i, nameColumnIndex);
            toRemove.add(name);
        }
        return toRemove;
    }

    public static void selectTableRow(JTable table, String columnName, String cellValue) {
        int colIdx = GuiHelper.getColumnIndex(table, columnName);
        int rowCount = table.getRowCount();
        for (int r = 0; r < rowCount; ++r) {
            String cellDbName;
            Object obj = table.getValueAt(r, colIdx);
            if (!(obj instanceof String) || (cellDbName = (String)obj) == null || !cellDbName.equalsIgnoreCase(cellValue)) continue;
            table.setRowSelectionInterval(r, r);
        }
    }

    public static TableModelBasic getTableModel(Object[][] data, boolean nullAsBlank) {
        int colCount = data[0].length;
        int rowCount = data.length;
        Object[][] dataOnly = new Object[rowCount - 1][colCount];
        for (int row = 1; row < rowCount; ++row) {
            dataOnly[row - 1] = data[row];
            for (int c = 0; c < colCount; ++c) {
                Object obj = data[row][c];
                if (obj != null && !obj.toString().equals(NULL_STR_UC)) continue;
                dataOnly[row - 1][c] = nullAsBlank ? "" : NULL_STR_UC;
            }
        }
        return new TableModelBasic(dataOnly, data[0]);
    }

    public static DefaultTableModel getBlankTableModel() {
        return blankTableModel__;
    }

    public static int getTabIndex(JTabbedPane pane, String title) {
        int index = -1;
        for (int i = 0; i < pane.getTabCount(); ++i) {
            String currentTitle = pane.getTitleAt(i);
            if (!title.equals(currentTitle)) continue;
            index = i;
            break;
        }
        return index;
    }

    public static void clearTabs(JTabbedPane tabPane) {
        while (tabPane.getTabCount() > 0) {
            tabPane.removeTabAt(tabPane.getTabCount() - 1);
        }
    }

    public static String getRowCountText(JTable table) {
        String strCount = table != null ? Integer.toString(table.getRowCount()) : "";
        return ResMgr.getRes("row.label.plural") + ": " + strCount;
    }

    public static void loadComboBox(JComboBox combo, Object[] items) {
        Object oldSelection = combo.getSelectedItem();
        int oldIndex = combo.getSelectedIndex();
        int oldCount = combo.getItemCount();
        combo.setModel(new DefaultComboBoxModel<Object>(items));
        if (oldSelection != null && items.length != oldCount) {
            combo.setSelectedItem(oldSelection);
        } else if (oldIndex >= 0 && items.length == oldCount) {
            combo.setSelectedIndex(oldIndex);
        }
    }

    public static void loadListModel(DefaultListModel model, Collection coll) {
        model.clear();
        Iterator it = coll.iterator();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
    }

    public static JMenuItem getMenuItemFromCmd(Command cmd) {
        String shortDesc = (String)cmd.getValue("ShortDescription");
        String longDesc = (String)cmd.getValue("LongDescription");
        Integer mnemonic = (Integer)cmd.getValue("MnemonicKey");
        ImageIcon icon = (ImageIcon)cmd.getValue("SmallIcon");
        JMenuItem mni = new JMenuItem(cmd);
        if (shortDesc != null) {
            mni.setText(shortDesc);
        }
        if (longDesc != null) {
            mni.setToolTipText(longDesc);
        }
        if (mnemonic != null) {
            mni.setMnemonic(mnemonic);
        }
        if (icon != null) {
            mni.setIcon(icon);
        }
        return mni;
    }

    public static JMenuItem getMenuItemFromAbstractAction(AbstractAction action) {
        String shortDesc = (String)action.getValue("ShortDescription");
        String longDesc = (String)action.getValue("LongDescription");
        Integer mnemonic = (Integer)action.getValue("MnemonicKey");
        ImageIcon icon = (ImageIcon)action.getValue("SmallIcon");
        JMenuItem mni = new JMenuItem(action);
        if (shortDesc != null) {
            mni.setText(shortDesc);
        }
        if (longDesc != null) {
            mni.setToolTipText(longDesc);
        }
        if (mnemonic != null) {
            mni.setMnemonic(mnemonic);
        }
        if (icon != null) {
            mni.setIcon(icon);
        }
        return mni;
    }

    public static void insertString(Document doc, String str, int offset) {
        try {
            doc.insertString(offset, str, new SimpleAttributeSet());
        }
        catch (BadLocationException e) {
            LogUtil.printStackTrace(e);
        }
    }

    public static Integer getNullableTextBoxInteger(JTextComponent component) {
        String textStr = component.getText();
        Integer intObj = null;
        if (!textStr.equals("")) {
            if (StrHelper.isNumeric(textStr)) {
                intObj = new Integer(textStr);
            } else {
                StrHelper.throwProgExcept("TextComponent: " + component.getName() + " value of: '" + textStr + "' is not numeric as expected.");
            }
        }
        return intObj;
    }

    public static Double getNullableTextBoxDouble(JTextComponent component) {
        String textStr = component.getText();
        Double dblObj = null;
        if (!textStr.equals("")) {
            if (StrHelper.isNumeric(textStr)) {
                dblObj = new Double(textStr);
            } else {
                StrHelper.throwProgExcept("TextComponent: " + component.getName() + " value of: '" + textStr + "' is not numeric as expected.");
            }
        }
        return dblObj;
    }

    public static String getEditorPaneText(JEditorPane editorPane) {
        return GuiHelper.getTextDocumentText(editorPane.getDocument());
    }

    public static String getTextDocumentText(Document doc) {
        String str = new String();
        try {
            str = doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            LogUtil.printStackTrace(e);
        }
        return str;
    }

    public static String getStyleNameAtPos(StyledDocument doc, int pos) {
        String styleName = (String)doc.getCharacterElement(pos).getAttributes().getAttribute(StyleConstants.NameAttribute);
        return styleName;
    }

    public static void applyAttributes(StyledDocument doc, SimpleAttributeSet attr, String subString) {
        String text = GuiHelper.getTextDocumentText(doc);
        ArrayList starts = StrHelper.getStringStarts(text, subString);
        int length = subString.length();
        Iterator it = starts.iterator();
        while (it.hasNext()) {
            int start = (Integer)it.next();
            doc.setCharacterAttributes(start, length, attr, false);
        }
    }

    public static boolean isMouseBtn1Down(MouseEvent mouseEvt) {
        int btn1Mask = 1024;
        boolean isBtnDown = (mouseEvt.getModifiersEx() & btn1Mask) == btn1Mask;
        return isBtnDown;
    }

    public static void setBusyCursor(Component comp) {
        comp.setCursor(BUSY_CURSOR);
    }

    public static void setDefaultCursor(Component comp) {
        comp.setCursor(DEFAULT_CURSOR);
    }

    public static void setFingerCursor(Component comp) {
        comp.setCursor(HAND_CURSOR);
    }

    public static void setHandCursor(Component comp) {
        GuiHelper.setFingerCursor(comp);
    }

    public static void setOpenHandCursor(Component comp) {
        if (openHandCursor__ == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            openHandCursor__ = tk.createCustomCursor(Icons.OPEN_HAND.getImage(), new Point(8, 8), "OpenHand");
        }
        comp.setCursor(openHandCursor__);
    }

    public static void setClosedHandCursor(Component comp) {
        if (openHandCursor__ == null) {
            Toolkit tk = Toolkit.getDefaultToolkit();
            closeHandCursor__ = tk.createCustomCursor(Icons.CLOSED_HAND.getImage(), new Point(8, 8), "ClosedHand");
        }
        comp.setCursor(closeHandCursor__);
    }

    public static void setAntiAliasOn(Graphics2D g2) {
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static BufferedImage getBufferedImage(int width, int height, boolean antiAlias) {
        BufferedImage image = new BufferedImage(width, height, 2);
        return image;
    }

    public static void setBackColor(Graphics2D g2, Color color, int width, int height) {
        Paint oldPaint = g2.getPaint();
        g2.setPaint(color);
        g2.fill(new Rectangle(width, height));
        g2.setPaint(oldPaint);
    }

    public static AlphaComposite getTransparentComposite(float alpha) {
        int type = 3;
        return AlphaComposite.getInstance(type, alpha);
    }

    public static Font getBoldFont(Font currentFont) {
        Font boldFont = new Font(currentFont.getName(), 1, currentFont.getSize());
        return boldFont;
    }

    public static Font getEnlargedBoldFont(Font inFont) {
        Font newFont = new Font(inFont.getFamily(), 1, inFont.getSize() + 1);
        return newFont;
    }

    public static void drawCenteredText(String s, int w, int h, Graphics g) {
        FontMetrics fm = g.getFontMetrics();
        int x = (w - fm.stringWidth(s)) / 2;
        int y = fm.getAscent() + (h - (fm.getAscent() + fm.getDescent())) / 2;
        g.drawString(s, x, y);
    }

    public static Stroke getThickStroke(int thickness) {
        return new BasicStroke(thickness, 0, 2);
    }

    public static Paint getGradientPaint(Rectangle bounds, Color color) {
        float midY = (float)((bounds.getMaxY() - bounds.getMinY()) / 2.0);
        GradientPaint paint = new GradientPaint((float)bounds.getMinX(), midY, Color.WHITE, (float)bounds.getMaxX(), midY, color);
        return paint;
    }

    public static Paint getGradientPaintVert(RoundRectangle2D rect, Color colorTop, Color colorBottom) {
        float midX = (float)((rect.getMaxX() - rect.getMinX()) / 2.0);
        GradientPaint paint = new GradientPaint(midX, (float)rect.getMinY(), colorTop, midX, (float)rect.getMaxY(), colorBottom);
        return paint;
    }

    public static Graphics2D getGraphics2D() {
        return (Graphics2D)GuiHelper.getBufferedImage(10, 10, false).getGraphics();
    }

    public static int getG2dStringWidth(Graphics2D g2, Font font, String str) {
        FontRenderContext frc = g2.getFontRenderContext();
        LineMetrics metrics = font.getLineMetrics(str, frc);
        int width = (int)font.getStringBounds(str, frc).getWidth();
        return width;
    }

    public static int getSwingStringLength(String msg, Font currentFont) {
        panel__.setFont(currentFont);
        fontMetrics__ = panel__.getFontMetrics(currentFont);
        int width = fontMetrics__.stringWidth(msg);
        return width;
    }

    public static int getSwingStringHeight(Font currentFont) {
        panel__.setFont(currentFont);
        fontMetrics__ = panel__.getFontMetrics(currentFont);
        int height = fontMetrics__.getHeight();
        return height;
    }

    public static int getMaxStringWidth(Font font, List strs) {
        int maxWidth = 0;
        FontMetrics metrics = GuiHelper.getFontMetrics(font);
        for (Object obj : strs) {
            if (!(obj instanceof String)) continue;
            String str = (String)obj;
            maxWidth = Math.max(maxWidth, metrics.stringWidth(str));
        }
        return maxWidth;
    }

    public static FontMetrics getFontMetrics(Font font) {
        return panel__.getFontMetrics(font);
    }

    public static Dimension getCenteredTextOrigin(Dimension rectSize, Font font, String msg) {
        int txtLength = GuiHelper.getSwingStringLength(msg, font);
        int txtHeight = GuiHelper.getSwingStringHeight(font);
        int x = (rectSize.width - txtLength) / 2;
        int y = (rectSize.height + txtHeight) / 2;
        Dimension origin = new Dimension(x, y);
        return origin;
    }

    public static void pushButton(AbstractButton button) throws Exception {
        ActionListener[] listeners = button.getActionListeners();
        if (listeners.length <= 0) {
            throw new Exception("No listeners have been added.");
        }
        listeners[0].actionPerformed(new ActionEvent(button, 0, EVENT_SOURCE));
    }

    public static JButton getStartBtn() {
        JButton btn = new JButton(ResMgr.getRes("start.button.label"), Icons.START);
        return btn;
    }

    public static JButton getSaveBtn() {
        JButton btn = new JButton(ResMgr.getRes("save"));
        btn.setMnemonic('S');
        btn.setName("btnSave");
        return btn;
    }

    public static JButton getCloseBtn() {
        JButton btn = new JButton(ResMgr.getRes("close"));
        btn.setMnemonic('C');
        btn.setName(BTN_CLOSE_NM);
        return btn;
    }

    public static JButton getSaveAndCloseBtn() {
        JButton btn = new JButton("Save & Close");
        btn.setMnemonic('A');
        btn.setName("btnSaveClose");
        return btn;
    }

    public static JButton getRefreshBtn() {
        JButton btn = new JButton("Refresh");
        btn.setMnemonic('R');
        btn.setName("btnRefresh");
        return btn;
    }

    public static JButton getUpdateBtn() {
        JButton btn = new JButton("Update");
        btn.setMnemonic('U');
        return btn;
    }

    public static void addCancelStroke(RootPaneContainer rootPaneCont) {
        CancelAction cancelAction = new CancelAction(rootPaneCont);
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        rootPaneCont.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        rootPaneCont.getRootPane().getActionMap().put("ESCAPE", cancelAction);
    }

    public static void nullifyKeystroke(InputMap im, KeyStroke ks) {
        Object key = im.get(ks);
        if (key != null) {
            im.put(ks, "none");
        }
    }

    public static Color getLighter(Color color) {
        return GuiHelper.getShiftedColor(color, 10);
    }

    public static Color getDarker(Color color) {
        return GuiHelper.getShiftedColor(color, -10);
    }

    public static Color getShiftedColor(Color color, int shift) {
        Color newColor = new Color(GuiHelper.shiftColorIndexSafely(color.getRed(), shift), GuiHelper.shiftColorIndexSafely(color.getGreen(), shift), GuiHelper.shiftColorIndexSafely(color.getBlue(), shift));
        return newColor;
    }

    private static int shiftColorIndexSafely(int index, int shift) {
        int newIndex = index + shift;
        if (newIndex > 255) {
            newIndex = 255;
        }
        if (newIndex < 0) {
            newIndex = 0;
        }
        return newIndex;
    }

    @Deprecated
    public static void setJGoodiesXpLaf() {
    }

    public static void setWinXpLaf() {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
        }
    }

    public static void setTestingLaf() {
        GuiHelper.setJGoodiesXpLaf();
    }

    @Deprecated
    private static int getDarkerDisp(int colorValue, int shift) {
        int newValue = colorValue - shift;
        if (newValue < 0) {
            newValue = 0;
        }
        return newValue;
    }

    static {
        emptyBorder__ = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        smallBorder__ = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        NULL_STR_UC = StrHelper.NULL_STR_UC;
        blankTableModel__ = new DefaultTableModel(new String[]{" "}, 0);
        BUSY_CURSOR = new Cursor(3);
        DEFAULT_CURSOR = new Cursor(0);
        HAND_CURSOR = new Cursor(12);
        CURSOR_MOVE = new Cursor(13);
        CURSOR_NW_RESIZE = new Cursor(6);
        CURSOR_N_RESIZE = new Cursor(8);
        CURSOR_NE_RESIZE = new Cursor(7);
        CURSOR_E_RESIZE = new Cursor(11);
        CURSOR_SE_RESIZE = new Cursor(5);
        CURSOR_S_RESIZE = new Cursor(9);
        CURSOR_SW_RESIZE = new Cursor(4);
        CURSOR_W_RESIZE = new Cursor(10);
        closeHandCursor__ = null;
        openHandCursor__ = null;
    }
}

