/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.display.status;

import com.harrand.coregui.helper.GuiHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.Timer;

public class FadingTextPanel
extends JPanel
implements ActionListener {
    private Timer fadeStepTimer = new Timer(30, this);
    private Timer fadeWaitTimer = new Timer(2500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FadingTextPanel.this.fadeWaitTimer.stop();
            FadingTextPanel.this.fadeStepTimer.start();
        }
    });
    private String text = "";
    private int opaqueIdx = 0;
    public static final int STEP_TIME = 30;
    public static final int FADE_STEPS = 50;
    public static final int WAIT_TIME = 2500;

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.drawText((Graphics2D)g);
    }

    public void setText(String text) {
        this.text = text;
        this.opaqueIdx = 0;
        this.redraw();
    }

    public void startWait() {
        this.fadeWaitTimer.start();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateState();
        this.redraw();
    }

    private void redraw() {
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    private void drawText(Graphics2D g2) {
        GuiHelper.setAntiAliasOn(g2);
        float alphaRatio = (float)(50 - this.opaqueIdx) / 50.0f;
        if (alphaRatio < 0.0f) {
            alphaRatio = 0.0f;
        }
        float colorAmount = 0.0f;
        g2.setPaint(new Color(colorAmount, colorAmount, colorAmount, alphaRatio));
        g2.drawString(this.text, 0, 12);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(450, 16);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void updateState() {
        ++this.opaqueIdx;
        if (this.isFadingDone()) {
            this.fadeStepTimer.stop();
        }
    }

    private boolean isFadingDone() {
        return this.opaqueIdx >= 50;
    }
}

