/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.display.status;

import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.text.QuickTimeFormat;
import com.harrand.coregui.Icons;
import com.harrand.coregui.helper.GuiHelper;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ClockPanel
extends JPanel
implements ActionListener {
    private Timer timer;
    private long startTime;
    private int iconIdx;
    private boolean isRunning = false;
    private String elapsedStr = "";
    private ImageIcon[] icons = Icons.SPINNER;
    private IObserver elapsedTimeObserver = null;
    public static final int DELAY_DEFAULT = 80;

    public ClockPanel() {
        this.timer = new Timer(80, this);
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
        this.iconIdx = 0;
        this.isRunning = true;
        this.timer.start();
    }

    public void stop() {
        this.timer.stop();
        this.isRunning = false;
        this.redraw();
    }

    public String getElapsedStr() {
        return this.elapsedStr;
    }

    public void setElapsedTimeObserver(IObserver elapsedTimeObserver) {
        this.elapsedTimeObserver = elapsedTimeObserver;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateState();
        this.redraw();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        GuiHelper.setAntiAliasOn(g2);
        if (this.isRunning) {
            g2.drawImage(this.icons[this.iconIdx].getImage(), 1, 1, null);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(20, 20);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    private void updateState() {
        this.updateElapseTimeStr();
        this.incrementIconIdx();
    }

    private void incrementIconIdx() {
        ++this.iconIdx;
        if (this.iconIdx >= this.icons.length) {
            this.iconIdx = 0;
        }
    }

    private void updateElapseTimeStr() {
        long currentTime = System.currentTimeMillis();
        String timeStr = QuickTimeFormat.formatterMinutes__.format(new Date(currentTime - this.startTime));
        this.elapsedStr = "(" + timeStr + " s)";
        if (this.elapsedTimeObserver != null) {
            this.elapsedTimeObserver.update(null);
        }
    }

    private void redraw() {
        this.invalidate();
        this.revalidate();
        this.repaint();
    }
}

