/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.display;

import com.harrand.coregui.helper.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;

public class UsedColorsPanel
extends AbstractColorChooserPanel {
    private List colors_ = new ArrayList();
    private Color selectedColor_ = null;
    private String title_ = "title";
    private JLabel lblDesc_ = new JLabel("Some description here..");
    private MouseListener lisMouse_;

    public void setUsedColors(List colors) {
        this.colors_ = this.getSortedColors(colors);
        this.buildChooser();
    }

    public void setTitle(String title) {
        this.title_ = title;
    }

    public void setDescText(String text) {
        this.lblDesc_.setText(text);
    }

    private List getSortedColors(List colors) {
        TreeMap<Integer, Color> treeMap = new TreeMap<Integer, Color>();
        for (Color color : colors) {
            int rgb = -color.getRGB();
            treeMap.put(new Integer(rgb), color);
        }
        return new ArrayList(treeMap.values());
    }

    private void setSelecteColor(Color color) {
        this.selectedColor_ = color;
    }

    private void buildListeners() {
        this.lisMouse_ = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                JLabel lbl = (JLabel)me.getSource();
                UsedColorsPanel.this.setSelecteColor(lbl.getBackground());
                UsedColorsPanel.this.updateChooser();
            }
        };
    }

    private JPanel getSwatchPanel() {
        int spots = 32;
        int pos = 0;
        JPanel panel = new JPanel(new GridLayout(4, 8));
        for (Color color : this.colors_) {
            JLabel lbl = new JLabel();
            lbl.setOpaque(true);
            lbl.setBackground(color);
            lbl.setForeground(color);
            lbl.setMinimumSize(new Dimension(20, 20));
            lbl.setPreferredSize(new Dimension(20, 20));
            lbl.setMaximumSize(new Dimension(20, 20));
            lbl.setBorder(BorderFactory.createRaisedBevelBorder());
            lbl.addMouseListener(this.lisMouse_);
            panel.add(lbl);
            ++pos;
        }
        for (int i = pos; i < spots; ++i) {
            panel.add(new JLabel());
        }
        return panel;
    }

    @Override
    protected void buildChooser() {
        this.buildListeners();
        this.removeAll();
        this.setLayout(new BorderLayout(4, 28));
        this.add((Component)this.lblDesc_, "North");
        this.add((Component)this.getSwatchPanel(), "Center");
        GuiHelper.addEmptyBorder(this);
    }

    @Override
    public String getDisplayName() {
        return this.title_;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public void updateChooser() {
        this.getColorSelectionModel().setSelectedColor(this.selectedColor_);
    }
}

