/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.display;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.ILafSettable;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.util.LogUtil;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class LafPanel
extends JPanel
implements ITitled,
ISized {
    private JLabel lblAvailableLafs_ = new JLabel("Available Look and Feels:");
    private JComboBox cboLaf_;
    private ILafSettable lafSettable_;
    private JButton btnSetLaf_ = new JButton("Set As Look and Feel");
    public static final String TITLE = "Set Look and Feel";

    public LafPanel(ILafSettable lafSettable) {
        this.lafSettable_ = lafSettable;
        this.setItems();
        this.layoutPanel();
        this.addListeners();
    }

    private void setItems() {
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < info.length; ++i) {
            String humanReadableName = info[i].getName();
            String className = info[i].getClassName();
            v.add(className);
            LogUtil.logMsg("lafPanel.readableName: " + humanReadableName);
            LogUtil.logMsg("lafPanel.className: " + className);
        }
        v.add("com.jgoodies.plaf.plastic.PlasticXPLookAndFeel");
        this.cboLaf_ = new JComboBox(v);
    }

    private void layoutPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createVerticalStrut(5));
        this.add(this.getCboPanel());
        this.add(Box.createVerticalStrut(5));
        this.add(this.getButtonPanel());
        this.add(Box.createGlue());
        GuiHelper.addEmptyBorder(this);
    }

    private JPanel getCboPanel() {
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel panel = new JPanel();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.addGridbagPair(this.lblAvailableLafs_, this.cboLaf_, gbc, panel, row);
        return panel;
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createGlue());
        buttonPanel.add(this.btnSetLaf_);
        return buttonPanel;
    }

    private void addListeners() {
        this.btnSetLaf_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String className = (String)LafPanel.this.cboLaf_.getSelectedItem();
                LafPanel.this.lafSettable_.setLaf(className);
            }
        });
    }

    @Override
    public String getTitle() {
        return TITLE;
    }

    @Override
    public String getToolTip() {
        return TITLE;
    }

    @Override
    public ImageIcon getIcon() {
        return Icons.NULL_ICON;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(50, 50, 450, 100);
    }
}

