/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.display;

import com.harrand.coreclasses.text.QuickTimeFormat;
import com.harrand.coregui.Icons;
import com.harrand.coregui.image.IIconTabPane;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.Timer;

public class Animator
implements ActionListener {
    private Timer timer_;
    private int tabPos_ = -1;
    private long startTime_;
    private int iconIdx_;
    private int delay_ = 80;
    private JLabel lblIcon_ = null;
    private JLabel lblTime_ = null;
    private IIconTabPane iconTabPane_ = null;
    private ImageIcon[] icons_ = Icons.SPINNER;
    private Icon oldLabelIcon_ = null;
    private Icon oldTabIcon_ = null;
    public static final int DELAY_DEFAULT = 80;

    public Animator() {
        this.timer_ = new Timer(this.delay_, this);
    }

    public void start() {
        this.startTime_ = System.currentTimeMillis();
        this.iconIdx_ = 0;
        if (this.isTabValid()) {
            this.oldTabIcon_ = this.iconTabPane_.getIconAt(this.tabPos_);
        }
        this.timer_.start();
    }

    public void stop() {
        this.timer_.stop();
        if (this.lblIcon_ != null) {
            this.lblIcon_.setIcon(this.oldLabelIcon_);
        }
        if (this.isTabValid()) {
            this.iconTabPane_.setIconAt(this.tabPos_, this.oldTabIcon_);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updateDisplay();
    }

    public void setIconLabel(JLabel lblIcon) {
        this.lblIcon_ = lblIcon;
        this.oldLabelIcon_ = this.lblIcon_.getIcon();
    }

    public void setTimeLabel(JLabel lblTime) {
        this.lblTime_ = lblTime;
    }

    public void setIconTabPane(IIconTabPane iconTabPane, int tabPos) {
        this.iconTabPane_ = iconTabPane;
        this.tabPos_ = tabPos;
    }

    private void updateDisplay() {
        if (this.lblIcon_ != null) {
            this.lblIcon_.setIcon(this.icons_[this.iconIdx_]);
        }
        if (this.isTabValid()) {
            this.iconTabPane_.setIconAt(this.tabPos_, this.icons_[this.iconIdx_]);
        }
        if (this.lblTime_ != null) {
            long currentTime = System.currentTimeMillis();
            String elapsedStr = QuickTimeFormat.formatterMinutes__.format(new Date(currentTime - this.startTime_));
            this.lblTime_.setText(elapsedStr);
        }
        ++this.iconIdx_;
        if (this.iconIdx_ >= this.icons_.length) {
            this.iconIdx_ = 0;
        }
    }

    private boolean isTabValid() {
        boolean valid = this.iconTabPane_ != null && this.tabPos_ >= 0;
        return valid;
    }
}

