/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.dialog;

import com.harrand.coreclasses.dataEntry.IDataEditPanel;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.OkCancelPanel;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public final class DataEditDlg
extends JDialog {
    private Frame dlgOwner_;
    private JPanel mainPanel_;
    private IDataEditPanel editPanel_;
    private OkCancelPanel okCancelPanel_ = new OkCancelPanel();
    private boolean okHit_ = false;
    private CancelAction cancelAction_ = new CancelAction();

    public DataEditDlg(JPanel mainPanel, Frame dlgOwner) {
        super(dlgOwner);
        this.checkDataEditPanel(mainPanel);
        this.mainPanel_ = mainPanel;
        this.editPanel_ = (IDataEditPanel)((Object)mainPanel);
        this.buildPanel();
        this.setCosmetics();
        this.addListeners();
    }

    private void buildPanel() {
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        cp.add("Center", this.mainPanel_);
        cp.add("South", this.okCancelPanel_);
        this.getRootPane().setDefaultButton(this.okCancelPanel_.btnOk);
    }

    private void addListeners() {
        this.addOkCancelListeners();
        this.setKeyStrokeMap();
    }

    public boolean getOkHit() {
        return this.okHit_;
    }

    private void setCosmetics() {
        Rectangle bounds = this.editPanel_.getPreferredBounds();
        this.setTitle(this.editPanel_.getTitle());
        this.setModal(true);
        ImageIcon icon = this.editPanel_.getIcon();
        if (icon != null) {
            GuiHelper.setIcon(this, icon);
        }
        GuiHelper.locateDialog(this, bounds);
    }

    private void checkDataEditPanel(JPanel mainPanel) {
        if (!(mainPanel instanceof IDataEditPanel)) {
            StrHelper.throwProgExcept("mainPanel must be instance of IDataEditPanel");
        }
    }

    private final void setKeyStrokeMap() {
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", this.cancelAction_);
    }

    private final void addOkCancelListeners() {
        this.okCancelPanel_.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataEditDlg.this.processOkHit(evt);
            }
        });
        this.okCancelPanel_.btnCancel.addActionListener(this.cancelAction_);
    }

    private void processOkHit(ActionEvent evt) {
        ITestResult result = this.editPanel_.save();
        if (!result.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, result.getSummary(), result.getDetail());
        } else {
            this.okHit_ = true;
            this.dispose();
        }
    }

    class CancelAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            DataEditDlg.this.okHit_ = false;
            DataEditDlg.this.dispose();
        }
    }
}

