/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.dataEntry.internet;

import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.element.InternetLink;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.util.SysUtil;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class InternetLinkLabel
extends JLabel
implements MouseListener,
Runnable {
    private InternetLink link;
    public final Color HOVER_COLOR = Colors.getFireBrick();
    public final Color LINK_COLOR = Colors.getBlueDark();

    public InternetLinkLabel(InternetLink link) {
        this.link = link;
        this.init();
    }

    public void showLink(boolean showFlag) {
        if (showFlag) {
            this.setText(this.link.getDisplayText());
        } else {
            this.setText(" ");
        }
    }

    private void init() {
        this.setForeground(this.LINK_COLOR);
        this.addMouseListener(this);
        this.setHorizontalAlignment(0);
        this.resetText();
    }

    private void resetText() {
        this.setText(this.link.getDisplayText());
    }

    private void openWebPage() {
        this.setText(this.link.getDisplayText() + " (opening link...)");
        try {
            SwingUtilities.invokeLater(this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        try {
            SysUtil.openPurchasePage(this.link.getURL());
        }
        catch (Exception exception) {
        }
        finally {
            this.resetText();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.openWebPage();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        GuiHelper.setHandCursor(this);
        this.setForeground(this.HOVER_COLOR);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        GuiHelper.setDefaultCursor(this);
        this.setForeground(this.LINK_COLOR);
    }
}

