/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.dataEntry;

import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.display.Colors;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coregui.helper.GuiHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class ScrollableErrorPanel
extends JPanel
implements ISized,
ITitled {
    private String title_;
    private JLabel lblDescr_;
    private JTextArea txtMsg_;
    public static final int TXT_AREA_LINES = 8;

    public ScrollableErrorPanel(String title, String descr, String msg) {
        this.title_ = title;
        this.lblDescr_ = new JLabel(descr);
        this.txtMsg_ = new JTextArea(msg);
        this.setupGui();
    }

    private void setupGui() {
        this.setTextAreaProps(this.txtMsg_);
        this.buildPanel();
        this.setCosmetics();
        this.setNames();
    }

    private void buildPanel() {
        JPanel iconPanel = GuiHelper.getIconSidePanel(UIManager.getIcon("OptionPane.warningIcon"));
        this.setLayout(new BorderLayout(4, 4));
        this.add((Component)iconPanel, "West");
        this.add((Component)this.getMainPanel(), "Center");
    }

    private JPanel getMainPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(4, 4));
        panel.add((Component)this.lblDescr_, "North");
        panel.add((Component)new JScrollPane(this.txtMsg_), "Center");
        return panel;
    }

    private void setTextAreaProps(JTextArea txtArea) {
        txtArea.setRows(8);
        txtArea.setLineWrap(true);
        txtArea.setWrapStyleWord(true);
        txtArea.setEditable(false);
        txtArea.setBackground(Colors.getGrayUltraLight());
    }

    private void setCosmetics() {
        Font lblFont = this.lblDescr_.getFont();
        this.txtMsg_.setFont(lblFont);
        GuiHelper.addBodyPanelBorder(this);
        GuiHelper.setBoldFont(this.lblDescr_);
    }

    private void setNames() {
        this.lblDescr_.setName("lblDescr");
        this.txtMsg_.setName("txtMsg");
    }

    @Override
    public Rectangle getPreferredBounds() {
        return new Rectangle(500, 250);
    }

    @Override
    public ImageIcon getIcon() {
        return null;
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    @Override
    public String getToolTip() {
        return this.title_;
    }
}

