/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.prompt;

import com.harrand.coreclasses.interfaces.INamed;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.Rename;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.text.TextInputPanel;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.ResMgr;

public final class PromptRename
extends Command {
    private INamed named_;
    private String oldName_;
    private String newName_;
    private String name_;

    public PromptRename(INamed named, String oldName) {
        this(named, oldName, Command.getStateDo());
    }

    public PromptRename(INamed named, String oldName, int state) {
        this.named_ = named;
        this.oldName_ = oldName;
        this.name_ = ResMgr.getRes("rename.label");
        this.setState(state);
        this.setProps();
    }

    @Override
    public Command duplicate() {
        PromptRename cmdNew = new PromptRename(this.named_, this.oldName_, this.getState());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        TextInputPanel textPanel = new TextInputPanel(FileHelper.getRes("rename.prompt"), this.oldName_);
        EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, textPanel, textPanel.getPreferredBounds(), FileHelper.getRes("rename.label"));
        dlg.setVisible(true);
        this.newName_ = textPanel.getText();
        if (dlg.getOkHit() && !this.newName_.equals(this.oldName_)) {
            Rename cmd = new Rename(this.named_, this.oldName_, this.newName_);
            cmd.setCommandChain(this.getCommandChain());
            this.setCommandChain(new CommandChain("ownChain"));
            try {
                cmd.actionPerformed(null);
            }
            catch (Exception e) {
                LogUtil.printStackTrace(e);
                GuiMessageHelper.showGeneralAppErrMsg(null, e.getMessage());
            }
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    @Override
    protected void undo() {
    }
}

