/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.prompt;

import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.idf.RemoveManyFromCollector;
import com.harrand.coregui.command.prompt.ConfirmRemoveUtil;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.util.LogUtil;
import java.util.List;

public final class PromptCollectionRemoveMany
extends Command {
    private Command removeManyCommand_ = null;
    private Collector collector_;
    private List identifiables_;
    private String mapName_;
    private String name_;

    public PromptCollectionRemoveMany(Collector collector, String mapName, List identifiables) {
        this(collector, mapName, identifiables, Command.getStateDo());
    }

    public PromptCollectionRemoveMany(Collector collector, String mapName, List identifiables, int state) {
        this.collector_ = collector;
        this.mapName_ = mapName;
        this.identifiables_ = identifiables;
        this.name_ = "Prompt Remove Many: " + this.mapName_;
        this.setState(state);
        this.setProps();
    }

    @Override
    public Command duplicate() {
        PromptCollectionRemoveMany cmdNew = new PromptCollectionRemoveMany(this.collector_, this.mapName_, this.identifiables_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        if (this.identifiables_.size() == 0) {
            LogUtil.logErr("PromptCollectionRemoveMany: No Identifiables.");
            return;
        }
        String msg = GuiMessageHelper.getDeleteConfirmPluralMsg(this.collector_.getDisplayPlural(this.mapName_), this.identifiables_.size());
        ConfirmRemoveUtil confirmRemoveUtil = new ConfirmRemoveUtil((Identifiable)this.identifiables_.get(0));
        boolean response = confirmRemoveUtil.checkConfirmed(msg);
        if (response) {
            this.removeManyCommand_ = new RemoveManyFromCollector(this.collector_, this.identifiables_);
            this.setCommandChain(new CommandChain("dummyChain"));
            this.removeManyCommand_.actionPerformed(null);
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.MINUS);
    }

    @Override
    protected void undo() {
    }
}

