/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.prompt;

import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.idf.RemoveFromCollector;
import com.harrand.coregui.command.prompt.ConfirmRemoveUtil;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.util.ResMgr;

public final class PromptCollectionRemove
extends Command {
    private Command removeCommand_ = null;
    private Collector collector_;
    private String identifiableName_;
    private String mapName_;
    private String name_;

    public PromptCollectionRemove(Collector collector, String mapName, String identifiableName) {
        this(collector, mapName, identifiableName, Command.getStateDo());
    }

    public PromptCollectionRemove(Collector collector, Identifiable identifiable) {
        this(collector, identifiable.getMapName(), identifiable.getName(), Command.getStateDo());
    }

    public PromptCollectionRemove(Collector collector, String mapName, String identifiableName, int state) {
        this.collector_ = collector;
        this.mapName_ = mapName;
        this.identifiableName_ = identifiableName;
        this.name_ = "Remove";
        this.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
        this.setState(state);
        this.setProps();
    }

    public void hideIcon(boolean hideIcon) {
        if (hideIcon) {
            this.putValue("SmallIcon", null);
        }
    }

    @Override
    public Command duplicate() {
        PromptCollectionRemove cmdNew = new PromptCollectionRemove(this.collector_, this.mapName_, this.identifiableName_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        ConfirmRemoveUtil confirmRemoveUtil = new ConfirmRemoveUtil(this.collector_, this.mapName_, this.identifiableName_);
        String msg = GuiMessageHelper.getDeleteConfirmationMsg(1, this.mapName_, this.identifiableName_);
        boolean response = confirmRemoveUtil.checkConfirmed(msg);
        if (response) {
            this.removeCommand_ = new RemoveFromCollector(this.collector_, this.mapName_, this.identifiableName_);
            this.removeCommand_.setCommandChain(this.getCommandChain());
            this.setCommandChain(new CommandChain("dummyChain"));
            try {
                this.removeCommand_.actionPerformed(null);
            }
            catch (Exception e) {
                String title = ResMgr.getRes("command.invalid.label");
                GuiMessageHelper.showInputErrMsg(null, title, e.getMessage());
            }
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.MINUS);
        this.putValue("MnemonicKey", new Integer(82));
    }

    @Override
    protected void undo() {
    }
}

