/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.prompt;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.IMultipleAddCtrl;
import com.harrand.coreclasses.dataEntry.IMultipleAddPanel;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coregui.EditDialog;
import com.harrand.coregui.Icons;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.GroupCommand;
import com.harrand.coregui.command.idf.AddToCollector;
import com.harrand.coregui.command.prompt.IHasPromptSubCmds;
import com.harrand.coregui.dataEntry.IFocusable;
import com.harrand.coregui.dialog.IParentDlgUser;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.util.LogUtil;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public final class PromptCollectionAdd
extends Command
implements ComponentListener,
IMultipleAddCtrl {
    private Command addCommand_ = null;
    private Collector collector_;
    private DataEditor dataEditor_;
    private String mapName_;
    private String name_;

    public PromptCollectionAdd(Collector collector, String mapName, DataEditor dataEditor) {
        this(collector, mapName, dataEditor, Command.getStateDo());
    }

    public PromptCollectionAdd(Collector collector, String mapName, DataEditor dataEditor, int state) {
        this.collector_ = collector;
        this.dataEditor_ = dataEditor;
        this.mapName_ = mapName;
        this.name_ = "Add " + this.collector_.getDisplayName(this.mapName_);
        this.setState(state);
        this.setProps();
    }

    private void addToCollector() {
        Collector panelColl = this.dataEditor_.getCollector();
        if (panelColl != null) {
            this.collector_ = panelColl;
        }
        AddToCollector addCmd = new AddToCollector(this.collector_, this.dataEditor_.getDataObject());
        Command subCmd = this.getSubCmd();
        if (subCmd != null) {
            ArrayList<Command> cmds = new ArrayList<Command>();
            cmds.add(addCmd);
            cmds.add(subCmd);
            String cmdNm = addCmd.getValue("Name") + ", " + subCmd.getValue("Name");
            this.addCommand_ = new GroupCommand(cmds, cmdNm);
        } else {
            this.addCommand_ = addCmd;
        }
        this.addCommand_.setCommandChain(CommandChainMgr.getCmdChain());
        this.setCommandChain(new CommandChain("dummyChain"));
        this.addCommand_.actionPerformed(null);
    }

    private Command getSubCmd() {
        Command subCmd;
        if (this.dataEditor_ instanceof IHasPromptSubCmds && (subCmd = ((IHasPromptSubCmds)((Object)this.dataEditor_)).getAddSubCmd()) != null) {
            return subCmd;
        }
        return null;
    }

    @Override
    public Command duplicate() {
        PromptCollectionAdd cmdNew = new PromptCollectionAdd(this.collector_, this.mapName_, this.dataEditor_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        if (this.dataEditor_ instanceof JPanel) {
            String title = this.dataEditor_.getTitle();
            EditDialog dlg = new EditDialog(ParentFrameSvr.instance().getParentFrame(), true, (JPanel)((Object)this.dataEditor_), this.dataEditor_.getPreferredBounds(), title);
            if (this.dataEditor_ instanceof IParentDlgUser) {
                ((IParentDlgUser)((Object)this.dataEditor_)).setParentDialog(dlg);
            }
            dlg.addComponentListener(this);
            dlg.setIsAddPanel(true);
            if (this.dataEditor_ instanceof IMultipleAddPanel) {
                dlg.setMultipleAddCtrl(this);
            }
            dlg.setVisible(true);
            if (dlg.getOkHit()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PromptCollectionAdd.this.addToCollector();
                    }
                });
            }
        } else {
            LogUtil.logErr("ERROR: DataEditor must be a JPanel for PromptCollectionAdd: " + this.name_ + " to work.");
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("SmallIcon", Icons.ADD);
        this.putValue("MnemonicKey", 65);
    }

    @Override
    protected void undo() {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.dataEditor_ instanceof IFocusable) {
            ((IFocusable)((Object)this.dataEditor_)).transferFocus();
        }
    }

    @Override
    public void addAndAddAnother() {
        if (this.dataEditor_ instanceof IMultipleAddPanel) {
            this.addToCollector();
            ((IMultipleAddPanel)((Object)this.dataEditor_)).resetUI();
        } else {
            LogUtil.logErr("PromptCollectionAdd.err: attempting to add multiple items to a non IMultipleAddPanel");
        }
    }
}

