/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.prompt;

import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IConfirmRemove;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;

public class ConfirmRemoveUtil {
    private Identifiable idf_;

    public ConfirmRemoveUtil(Collector collector, String mapName, String identifiableName) {
        this.idf_ = this.getIdf(collector, mapName, identifiableName);
    }

    public ConfirmRemoveUtil(Identifiable idf) {
        this.idf_ = idf;
    }

    public boolean checkConfirmed(String msg) {
        boolean confirmRemove;
        boolean confirmed = true;
        boolean bl = confirmRemove = this.idf_ != null ? this.getConfirmRemove(this.idf_) : false;
        if (confirmRemove) {
            confirmed = GuiMessageHelper.showYesNoMsg(null, FileHelper.getResource("title.confirm.delete"), msg);
        }
        return confirmed;
    }

    private boolean getConfirmRemove(Identifiable idf) {
        boolean confirmRemove = true;
        if (idf instanceof IConfirmRemove) {
            confirmRemove = ((IConfirmRemove)((Object)idf)).getConfirmRemove();
        }
        return confirmRemove;
    }

    private Identifiable getIdf(Collector collector, String mapName, String identifiableName) {
        Identifiable idf = collector.get(mapName, identifiableName);
        if (idf == null) {
            LogUtil.logErr("ConfirmRemoveUtil: Could not find identifiable");
        }
        return idf;
    }
}

