/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.idf;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.rename.IRenameTrackable;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.idf.RenameIdf;
import com.harrand.util.LogUtil;

public final class UpdateInCollector
extends Command {
    private Collector collector_;
    private Identifiable oldIdf_;
    private Identifiable newIdf_;
    private String name_;
    private RenameMgr renameMgr_ = null;
    private int renameId_ = 0;

    public UpdateInCollector(Collector collector, Identifiable oldIdf, Identifiable newIdf) {
        this(collector, oldIdf, newIdf, Command.getStateDo());
    }

    public UpdateInCollector(Collector collector, Identifiable oldIdf, Identifiable newIdf, int state) {
        this.collector_ = collector;
        this.oldIdf_ = oldIdf;
        this.newIdf_ = newIdf;
        String idfNm = oldIdf.getName();
        if (StrHelper.isInteger(idfNm)) {
            idfNm = oldIdf.getMapName();
        }
        this.name_ = "Update " + idfNm;
        this.setState(state);
        this.setProps();
    }

    public static void doUpdate(Collector collector, Identifiable oldIdf, Identifiable newIdf, CommandChain chain, RenameMgr renameMgr) {
        UpdateInCollector.doUpdate(collector, oldIdf, newIdf, chain, renameMgr, true);
    }

    public static void doUpdate(Collector collector, Identifiable oldIdf, Identifiable newIdf, CommandChain chain, RenameMgr renameMgr, boolean doAutoSave) {
        UpdateInCollector updateCommand = new UpdateInCollector(collector, oldIdf, newIdf);
        updateCommand.setCommandChain(chain);
        updateCommand.setRenameMgr(renameMgr);
        updateCommand.setDoAutoSave(doAutoSave);
        updateCommand.actionPerformed(null);
    }

    public void setRenameMgr(RenameMgr renameMgr) {
        this.renameMgr_ = renameMgr;
    }

    public void setRenameId(int renameId) {
        this.renameId_ = renameId;
    }

    @Override
    public Command duplicate() {
        UpdateInCollector cmdNew = new UpdateInCollector(this.collector_, this.oldIdf_, this.newIdf_);
        cmdNew.setRenameMgr(this.renameMgr_);
        cmdNew.setRenameId(this.renameId_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        ITestResult result = this.collector_.updateItem(this.oldIdf_, this.newIdf_);
        if (result.getPassed()) {
            String newName;
            String oldName;
            if (this.renameMgr_ != null && this.newIdf_ instanceof IRenameTrackable && !(oldName = this.oldIdf_.getName()).equals(newName = this.newIdf_.getName())) {
                this.renameId_ = RenameIdf.addRename((IRenameTrackable)((Object)this.newIdf_), this.collector_, this.renameMgr_, oldName, newName, -1);
            }
        } else {
            LogUtil.logErr("UpdInColl.updateItem() failed: " + result.getDetail());
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    @Override
    protected void undo() {
        this.collector_.updateItem(this.newIdf_, this.oldIdf_);
        if (this.renameMgr_ != null && this.renameId_ > 0) {
            this.renameMgr_.removeRename(this.renameId_);
        }
    }

    public String toString() {
        return "UpdateInCollector{collector_=" + this.collector_ + "oldIdf_=" + this.oldIdf_ + "newIdf_=" + this.newIdf_ + "name_=" + this.name_ + "renameMgr_=" + this.renameMgr_ + "renameId_=" + this.renameId_ + '}';
    }
}

