/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.idf;

import com.harrand.coreclasses.element.IIntermediateCollector;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.rename.IRenameTrackable;
import com.harrand.coreclasses.rename.Rename;
import com.harrand.coreclasses.rename.RenameContext;
import com.harrand.coreclasses.rename.RenameMgr;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.util.ResMgr;

public final class RenameIdf
extends Command {
    private Collector collector_;
    private Identifiable idf_;
    private String oldName_;
    private String newName_;
    private RenameMgr renameMgr_ = null;
    private int renameId_ = -1;
    private String name_;

    public RenameIdf(Collector collector, Identifiable idf, String oldName, String newName, CommandChain cmdChain) {
        this(collector, idf, oldName, newName, cmdChain, RenameIdf.getStateDo());
    }

    public RenameIdf(Collector collector, Identifiable idf, String oldName, String newName, CommandChain cmdChain, int state) {
        this.collector_ = collector;
        this.idf_ = idf;
        this.oldName_ = oldName;
        this.newName_ = newName;
        this.name_ = ResMgr.getRes("rename.label") + ": " + this.oldName_;
        this.setState(state);
        this.setProps();
        this.setCommandChain(cmdChain);
    }

    public void setRenameMgr(RenameMgr renameMgr) {
        this.renameMgr_ = renameMgr;
    }

    public void setRenameId(int renameId) {
        this.renameId_ = renameId;
    }

    @Override
    public Command duplicate() {
        RenameIdf cmdNew = new RenameIdf(this.collector_, this.idf_, this.oldName_, this.newName_, this.getCommandChain(), this.getState());
        this.cloneCommon(cmdNew);
        cmdNew.setRenameMgr(this.renameMgr_);
        cmdNew.setRenameId(this.renameId_);
        return cmdNew;
    }

    @Override
    protected void execute() {
        this.collector_.rename(this.idf_, this.oldName_, this.newName_);
        if (this.renameMgr_ != null && this.idf_ instanceof IRenameTrackable) {
            int id;
            this.renameId_ = id = RenameIdf.addRename((IRenameTrackable)((Object)this.idf_), this.collector_, this.renameMgr_, this.oldName_, this.newName_, this.renameId_);
        }
    }

    public static int addRename(IRenameTrackable trackable, Collector collector, RenameMgr mgr, String oldName, String newName, int reUseId) {
        String parentClsNm = trackable.getParentClassNm();
        String parentNm = parentClsNm != null ? collector.getName() : null;
        String superCollNm = null;
        String superCollClz = null;
        if (collector instanceof IIntermediateCollector) {
            IIntermediateCollector intermediate = (IIntermediateCollector)((Object)collector);
            superCollNm = intermediate.getSuperCollector().getName();
            superCollClz = intermediate.getSuperCollector().getMapName();
        }
        RenameContext ctx = new RenameContext(trackable.getMapName(), parentNm, parentClsNm, superCollNm, superCollClz);
        int renameId = reUseId < 0 ? mgr.getNextRenameId() : reUseId;
        Rename rnm = new Rename(renameId, oldName, newName);
        mgr.addRename(rnm, ctx);
        return renameId;
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    @Override
    protected void undo() {
        Identifiable newIdf = this.collector_.get(this.idf_.getMapName(), this.newName_);
        this.collector_.rename(newIdf, this.newName_, this.oldName_);
        if (this.renameMgr_ != null && this.renameId_ > 0) {
            this.renameMgr_.removeRename(this.renameId_);
        }
    }
}

