/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.idf;

import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.dbwrench.diagram.DbTableGlyph;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.ForeignKey;
import com.harrand.dbwrench.object.Schema;
import com.harrand.dbwrench.object.Table;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.LogUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoveTableCmd
extends Command {
    private final Database db;
    private final Table table;
    private Map removedDiagramGlyphsMap = null;
    private List removedFks = null;
    private String cmdName;

    public RemoveTableCmd(Database db, Table table) {
        this.db = db;
        this.table = table;
        this.buildObject();
        this.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
    }

    private RemoveTableCmd(Database db, Table table, Map removedDiagramGlyphsMap, List removedFks) {
        this(db, table);
        this.removedDiagramGlyphsMap = removedDiagramGlyphsMap;
        this.removedFks = removedFks;
    }

    private void buildObject() {
        this.cmdName = "Remove Table";
        this.setProps();
    }

    @Override
    protected void execute() {
        String tableNm = this.table.getName();
        String tblDotNote = this.table.getDotNote();
        this.removedDiagramGlyphsMap = new HashMap();
        for (Diagram diagram : this.db.getDiagrams()) {
            List<String> glyphNames = diagram.getGlyphNames();
            if (!glyphNames.contains(tblDotNote)) continue;
            DbTableGlyph glyph = (DbTableGlyph)diagram.getGlyph(tblDotNote);
            this.removedDiagramGlyphsMap.put(diagram.getName(), glyph);
            diagram.removeGlyph(tblDotNote);
        }
        this.removedFks = new ArrayList();
        for (ForeignKey fk : this.db.getFkUtil().getAllFks()) {
            String parDotNote = fk.getParTbl().getDotNote();
            if (!parDotNote.equalsIgnoreCase(tblDotNote)) continue;
            this.removedFks.add(fk);
        }
        for (ForeignKey fk : this.removedFks) {
            Table chdTbl = fk.getChdTbl();
            chdTbl.remove(ForeignKey.getClassName(), fk.getName());
        }
        try {
            Schema schema = this.table.getSchema();
            schema.remove(Table.getClassName(), tableNm);
        }
        catch (Exception e) {
            LogUtil.logErr("RemoveTableCmd.err: " + e.getMessage());
        }
    }

    @Override
    protected void undo() {
        Schema schema = this.table.getSchema();
        schema.add(this.table);
        for (ForeignKey fk : this.removedFks) {
            Table chdTbl = fk.getChdTbl();
            chdTbl.add(fk);
        }
        for (String diagramNm : this.removedDiagramGlyphsMap.keySet()) {
            Diagram diagram = this.db.getDiagram(diagramNm);
            DbTableGlyph glyph = (DbTableGlyph)this.removedDiagramGlyphsMap.get(diagramNm);
            diagram.addGlyph(glyph);
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.cmdName;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
        this.putValue("MnemonicKey", 82);
    }

    @Override
    public Command duplicate() {
        RemoveTableCmd cmdNew = new RemoveTableCmd(this.db, this.table, this.removedDiagramGlyphsMap, this.removedFks);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }
}

