/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command.idf;

import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.helper.GuiMessageHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class RemoveManyFromCollector
extends Command {
    private Collector collector_;
    private List<Identifiable> identifiables_;
    private String name_;

    public RemoveManyFromCollector(Collector collector) {
        this(collector, new ArrayList(), Command.getStateDo());
    }

    public RemoveManyFromCollector(Collector collector, List identifiables) {
        this(collector, identifiables, Command.getStateDo());
    }

    public RemoveManyFromCollector(Collector collector, List identifiables, int state) {
        this.collector_ = collector;
        this.identifiables_ = identifiables;
        this.name_ = "Remove Many from: " + this.collector_.getName();
        this.setState(state);
        this.setProps();
        this.setCommandChain(CommandChainMgr.getInstance().getCommandChain());
    }

    public void addIdentifiable(Identifiable identifiable) {
        this.identifiables_.add(identifiable);
    }

    @Override
    public Command duplicate() {
        RemoveManyFromCollector cmdNew = new RemoveManyFromCollector(this.collector_, this.identifiables_, Command.getStateDo());
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        for (Identifiable idf : this.identifiables_) {
            try {
                this.collector_.remove(idf.getMapName(), idf.getName());
            }
            catch (Exception e) {
                GuiMessageHelper.showInputErrMsg(null, "Remove Failed", e.getMessage());
            }
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    @Override
    protected void undo() {
        Iterator<Identifiable> it = this.identifiables_.iterator();
        while (it.hasNext()) {
            this.collector_.add(it.next());
        }
    }
}

