/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command;

import com.harrand.coreclasses.display.IColorable;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.command.Command;
import com.harrand.util.ResMgr;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SetColor
extends Command {
    private Color newColor_;
    private List colorables_;
    private Map oldColors_;
    private String key_;
    private String name_;
    private IObserver observer_;

    public SetColor(List colorables, String key, Color newColor) {
        this.setValues(colorables, key, newColor);
        this.oldColors_ = this.getOldColors();
    }

    public SetColor(List colorables, String key, Color newColor, Map oldColors) {
        this.setValues(colorables, key, newColor);
        this.oldColors_ = oldColors;
    }

    public void setObserver(IObserver observer) {
        this.observer_ = observer;
    }

    private void setValues(List colorables, String key, Color newColor) {
        SetColor.checkColorables(colorables);
        this.colorables_ = colorables;
        this.key_ = key;
        this.newColor_ = newColor;
        this.setEnabled(!this.colorables_.isEmpty());
        this.setProps();
        this.setName();
    }

    private void setName() {
        this.name_ = this.key_.equals("MainBox") ? ResMgr.getRes("color.back") : (this.key_.equals("MainText") ? ResMgr.getRes("color.fore") : ResMgr.getRes("color.type.unknown"));
    }

    private Map getOldColors() {
        HashMap<IColorable, Color> oldColors = new HashMap<IColorable, Color>();
        for (IColorable colorable : this.colorables_) {
            oldColors.put(colorable, colorable.getColor(this.key_));
        }
        return oldColors;
    }

    public static boolean checkColorables(List colorables) {
        boolean ok = true;
        for (Object obj : colorables) {
            if (obj instanceof IColorable) continue;
            ok = false;
            StrHelper.throwProgExcept("Not instance of IColorable: " + obj.toString());
        }
        return ok;
    }

    @Override
    public Command duplicate() {
        SetColor cmdNew = new SetColor(this.colorables_, this.key_, this.newColor_, this.oldColors_);
        cmdNew.setObserver(this.observer_);
        this.cloneCommon(cmdNew);
        return cmdNew;
    }

    @Override
    protected void execute() {
        for (IColorable colorable : this.colorables_) {
            colorable.setColor(this.key_, this.newColor_);
        }
        if (this.observer_ != null) {
            this.observer_.update(new UpdateChain(this));
        }
    }

    @Override
    protected void setProps() {
        String display = this.getDoPrefix() + this.name_;
        this.putValue("Name", display);
        this.putValue("ShortDescription", display);
        this.putValue("LongDescription", display);
    }

    @Override
    protected void undo() {
        for (IColorable colorable : this.colorables_) {
            Color oldColor = (Color)this.oldColors_.get(colorable);
            colorable.setColor(this.key_, oldColor);
        }
        if (this.observer_ != null) {
            this.observer_.update(new UpdateChain(this));
        }
    }
}

