/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui.command;

import com.harrand.coregui.command.CommandChain;
import com.harrand.dbwrenchnb.lifecycle.db.DbSaveChecker;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;

public abstract class Command
extends AbstractAction {
    private int state_ = 0;
    private ArrayList subCommands_ = new ArrayList();
    private CommandChain chain_ = null;
    private boolean doAutoSave = true;

    public void setState(int state) {
        this.state_ = state;
    }

    public void setCommandChain(CommandChain chain) {
        this.chain_ = chain;
    }

    public CommandChain getCommandChain() {
        return this.chain_;
    }

    public int getState() {
        return this.state_;
    }

    public static int getStateDo() {
        return 0;
    }

    public static int getStateUndo() {
        return 1;
    }

    public static int getStateRedo() {
        return 2;
    }

    public boolean isDoAutoSave() {
        return this.doAutoSave;
    }

    public void setDoAutoSave(boolean doAutoSave) {
        this.doAutoSave = doAutoSave;
    }

    public void addSubCommand(Command sub) {
        this.subCommands_.add(sub);
    }

    public ArrayList getSubCommands() {
        return new ArrayList(this.subCommands_);
    }

    public int getSubCommandCount() {
        return this.subCommands_.size();
    }

    protected void setSubCommands(ArrayList subs) {
        this.subCommands_ = new ArrayList(subs);
    }

    protected abstract void execute();

    protected abstract void undo();

    protected abstract void setProps();

    public abstract Command duplicate();

    protected void cloneCommon(Command newCommand) {
        newCommand.setSubCommands(this.subCommands_);
        newCommand.setCommandChain(this.chain_);
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        if (this.getState() == Command.getStateDo() || this.getState() == Command.getStateRedo()) {
            this.doSubs();
            this.execute();
            if (this.doAutoSave) {
                new DbSaveChecker().checkAutoSave();
            }
        } else {
            this.undo();
            this.undoSubs();
        }
        if (this.chain_ != null) {
            this.chain_.processCommand(this);
        }
    }

    private void doSubs() {
        for (Command sub : this.subCommands_) {
            sub.setState(this.getState());
            sub.actionPerformed(null);
        }
    }

    private void undoSubs() {
        for (int i = this.subCommands_.size() - 1; i >= 0; --i) {
            Command sub = (Command)this.subCommands_.get(i);
            sub.setState(this.getState());
            sub.actionPerformed(null);
        }
    }

    protected String getDoPrefix() {
        String prefix = "";
        if (this.getState() == Command.getStateDo()) {
            prefix = "";
        } else if (this.getState() == Command.getStateUndo()) {
            prefix = "Undo ";
        } else if (this.getState() == Command.getStateRedo()) {
            prefix = "Redo ";
        }
        return prefix;
    }
}

