/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coregui.image.ImageUtil;
import com.harrand.util.LogUtil;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;

public final class Icons {
    private static Map classIconMap__ = new HashMap();
    private static Map bufferedImages__;
    private static Toolkit toolkit__;
    public static final String ANCHOR_KEY = "Anchor";
    public static final String FK_KEY = "Fk";
    public static final String COLUMN_ADD_KEY = "column_add";
    public static final String INDEX_KEY = "Index";
    public static final String CHECK_SM_KEY = "CheckSm";
    public static final String CHECK_SM_TRANS_KEY = "CheckSmTrans";
    public static final String PK_KEY = "Pk";
    public static final String PK_GRAY_KEY = "pk_gray";
    public static final String INDEX_GRAY_KEY = "index_gray";
    public static final String NULLABLE_GRAY_KEY = "nullable_gray";
    public static final String NULLABLE_KEY = "nullable";
    public static final String FK_GRAY_KEY = "fk_gray";
    public static final String DELETE_X_KEY = "delete_x";
    public static final String TABLE_KEY = "Table";
    public static final String NOTE_KEY = "Note";
    public static final String ZONE_KEY = "Zone";
    public static final String TABLE_DATA_VIEWER_KEY = "table_data_viewer";
    public static final String NOTE_ICON_SVG_ID = "note_icon";
    public static final String TABLE_ICON_SVG_ID = "table_icon";
    public static final String PK_ICON_SVG_ID = "pk_icon";
    public static final String FK_ICON_SVG_ID = "fk_icon";
    public static final String NULLABLE_ICON_SVG_ID = "nullable_icon";
    public static final String ZONE_ICON_SVG_ID = "zone_icon";
    public static final String INDEX_ICON_SVG_ID = "index_icon";
    public static final ImageIcon ABOUT;
    public static final ImageIcon ABOUT_BIG;
    public static final ImageIcon ADD;
    public static final ImageIcon ADD_MULTI;
    public static final ImageIcon ALIGN_CENTER;
    public static final ImageIcon ALIGN_LEFT;
    public static final ImageIcon ALIGN_RIGHT;
    public static final ImageIcon ANCHOR;
    public static final ImageIcon BOLD;
    public static final ImageIcon CANCEL;
    public static final ImageIcon CASCADE;
    public static final ImageIcon CAUTION;
    public static final ImageIcon CLICK_ACTIONS_OFF;
    public static final ImageIcon CLICK_ACTIONS_ON;
    public static final ImageIcon CLOSE;
    public static final ImageIcon CLOSED_HAND;
    public static final ImageIcon CLOCK;
    public static final ImageIcon CHECK_SM;
    public static final ImageIcon CHECK_SM_TRANS;
    public static final ImageIcon CHECK_BASIC;
    public static final ImageIcon CHECK_FAT;
    public static final ImageIcon COLUMN;
    public static final ImageIcon COLUMN_ADD;
    public static final ImageIcon COMMENT;
    public static final ImageIcon CONN_CFG;
    public static final ImageIcon CONNECT;
    public static final ImageIcon CORNER;
    public static final ImageIcon COPY;
    public static final ImageIcon CUT;
    public static final ImageIcon CUSTOM_TYPE;
    public static final ImageIcon DATABASE;
    public static final ImageIcon DB_COMPARE_REFRESH;
    public static final ImageIcon DB_EXPL;
    public static final ImageIcon DB_DOC;
    public static final ImageIcon DELETE;
    public static final ImageIcon DISCONNECT;
    public static final ImageIcon DIAGRAM;
    public static final ImageIcon ERASE;
    public static final ImageIcon ERROR;
    public static final ImageIcon EXECUTE;
    public static final ImageIcon EXIT;
    public static final ImageIcon FOREIGN_KEY;
    public static final ImageIcon FK_GRAY;
    public static final ImageIcon FK_ADD;
    public static final ImageIcon FIND;
    public static final ImageIcon FILE_PATH;
    public static final ImageIcon FROM_SERVER;
    public static final ImageIcon HELP_CONTENTS;
    public static final ImageIcon ITALIC;
    public static final ImageIcon LOGO;
    public static final ImageIcon INDEX;
    public static final ImageIcon INDEX_GRAY;
    public static final ImageIcon MINUS;
    public static final ImageIcon MYSQL;
    public static final ImageIcon NAVIGATOR;
    public static final ImageIcon NEW;
    public static final ImageIcon NOTE;
    public static final ImageIcon NULL_ICON;
    public static final ImageIcon NULLABLE;
    public static final ImageIcon NULLABLE_GRAY;
    public static final ImageIcon OK;
    public static final ImageIcon OPEN;
    public static final ImageIcon OPEN_HAND;
    public static final ImageIcon OPTIONS;
    public static final ImageIcon PASTE;
    public static final ImageIcon PIN;
    public static final ImageIcon PK;
    public static final ImageIcon PK_GRAY;
    public static final ImageIcon PK1;
    public static final ImageIcon PK2;
    public static final ImageIcon PK3;
    public static final ImageIcon PK4;
    public static final ImageIcon PK5;
    public static final ImageIcon PK6;
    public static final ImageIcon PK7;
    public static final ImageIcon PK8;
    public static final ImageIcon PK9;
    public static final ImageIcon PREFERENCES;
    public static final ImageIcon PRINT;
    public static final ImageIcon PROC;
    public static final ImageIcon PROPS;
    public static final ImageIcon QUERY;
    public static final ImageIcon QUERY_BLDR;
    public static final ImageIcon QUESTION_DLG;
    public static final ImageIcon QUESTION;
    public static final ImageIcon QUESTION_SMALL;
    public static final ImageIcon REMOVE_GLYPH;
    public static final ImageIcon REPLACE;
    public static final ImageIcon REDO;
    public static final ImageIcon REFRESH;
    public static final ImageIcon REVERSE;
    public static final ImageIcon REV_SYNC;
    public static final ImageIcon SCRIPT;
    public static final ImageIcon SAVE;
    public static final ImageIcon SAVE_AS;
    public static final ImageIcon SCHEMA;
    public static final ImageIcon SCRIPT_CALC;
    public static final ImageIcon SEARCH;
    public static final ImageIcon SERVER;
    public static final ImageIcon SEQUENCE;
    public static final ImageIcon SPLASH;
    public static final ImageIcon STATUS_BORDER_TOP;
    public static final ImageIcon STATUS_BORDER_BTM;
    public static final ImageIcon START;
    public static final ImageIcon STEP;
    public static final ImageIcon STOP;
    public static final ImageIcon SECURITY;
    public static final ImageIcon SUCCESS;
    public static final ImageIcon SQL_COMM;
    public static final ImageIcon TABLE;
    public static final ImageIcon TABLE_ADD;
    public static final ImageIcon TABLE_DATA;
    public static final ImageIcon TABLE_DATA_VIEWER;
    public static final ImageIcon TEXT;
    public static final ImageIcon TRIGGER;
    public static final ImageIcon TO_SERVER;
    public static final ImageIcon UNDERLINE;
    public static final ImageIcon UNCOMMENT;
    public static final ImageIcon UNDO;
    public static final ImageIcon UNIQUE_CONSTRAINT;
    public static final ImageIcon VERT_STRIP;
    public static final ImageIcon VIEW;
    public static final ImageIcon WARNING;
    public static final ImageIcon ZONE;
    public static final ImageIcon ZOOM_IN;
    public static final ImageIcon ZOOM_OUT;
    public static final ImageIcon[] PKS;
    public static final ImageIcon[] SPINNER;

    public static ImageIcon loadImage(String imageName) {
        try {
            URL url = Icons.getUrl(imageName);
            return new ImageIcon(toolkit__.getImage(url));
        }
        catch (Exception e) {
            LogUtil.printStackTrace(e);
            return new ImageIcon();
        }
    }

    public static URL getUrl(String imageName) {
        URL url = Icons.class.getResource("images/" + imageName);
        if (url == null) {
            StrHelper.throwProgExcept("Icons.can not url: " + imageName);
        }
        return url;
    }

    public static BufferedImage getBufferedImage(String key) {
        Icons.ensureInitBufferedImages();
        return (BufferedImage)bufferedImages__.get(key);
    }

    private static void ensureInitBufferedImages() {
        if (bufferedImages__ == null) {
            bufferedImages__ = new TreeMap();
            bufferedImages__.put(TABLE_KEY, ImageUtil.toBufferedImage(TABLE.getImage()));
            bufferedImages__.put(TABLE_DATA_VIEWER_KEY, ImageUtil.toBufferedImage(TABLE_DATA_VIEWER.getImage()));
            bufferedImages__.put(FK_KEY, ImageUtil.toBufferedImage(FOREIGN_KEY.getImage()));
            bufferedImages__.put(INDEX_KEY, ImageUtil.toBufferedImage(INDEX.getImage()));
            bufferedImages__.put(NULLABLE_KEY, ImageUtil.toBufferedImage(NULLABLE.getImage()));
            bufferedImages__.put(PK_KEY, ImageUtil.toBufferedImage(PK.getImage()));
            bufferedImages__.put(PK_GRAY_KEY, ImageUtil.toBufferedImage(PK_GRAY.getImage()));
            bufferedImages__.put(COLUMN_ADD_KEY, ImageUtil.toBufferedImage(COLUMN_ADD.getImage()));
            bufferedImages__.put(NULLABLE_GRAY_KEY, ImageUtil.toBufferedImage(NULLABLE_GRAY.getImage()));
            bufferedImages__.put(FK_GRAY_KEY, ImageUtil.toBufferedImage(FK_GRAY.getImage()));
            bufferedImages__.put(INDEX_GRAY_KEY, ImageUtil.toBufferedImage(INDEX_GRAY.getImage()));
            bufferedImages__.put(DELETE_X_KEY, ImageUtil.toBufferedImage(CANCEL.getImage()));
            bufferedImages__.put(NOTE_KEY, ImageUtil.toBufferedImage(PIN.getImage()));
            bufferedImages__.put(ZONE_KEY, ImageUtil.toBufferedImage(ZONE.getImage()));
            bufferedImages__.put(ANCHOR_KEY, ImageUtil.toBufferedImage(ANCHOR.getImage()));
            bufferedImages__.put(CHECK_SM_KEY, ImageUtil.toBufferedImage(CHECK_SM.getImage()));
            bufferedImages__.put(CHECK_SM_TRANS_KEY, ImageUtil.toBufferedImage(CHECK_SM_TRANS.getImage()));
            for (int i = 0; i < PKS.length; ++i) {
                int j = i + 1;
                bufferedImages__.put(PK_KEY + j, ImageUtil.toBufferedImage(PKS[i].getImage()));
            }
        }
    }

    public static ImageIcon getPkIcon(int pos) {
        ImageIcon icon = NULL_ICON;
        icon = pos < 0 ? NULL_ICON : (pos == 0 ? PK : (pos > 0 && pos <= 9 ? PKS[pos - 1] : PKS[8]));
        return icon;
    }

    public static BufferedImage getPkBufferedImg(int pos) {
        BufferedImage img = null;
        if (pos < 0) {
            img = null;
        } else if (pos == 0) {
            img = Icons.getBufferedImage(PK_KEY);
        } else if (pos > 0 && pos <= 9) {
            String key = PK_KEY + pos;
            img = Icons.getBufferedImage(key);
        } else {
            img = Icons.getBufferedImage("Pk9");
        }
        return img;
    }

    public static ImageIcon getClazzIcon(String className) {
        ImageIcon icon;
        if (classIconMap__.isEmpty()) {
            Icons.loadClassIconMap();
        }
        if ((icon = (ImageIcon)classIconMap__.get(className)) == null) {
            icon = NULL_ICON;
        }
        return icon;
    }

    private static void loadClassIconMap() {
        LogUtil.logMsg("Icons.must renable.");
    }

    static {
        toolkit__ = Toolkit.getDefaultToolkit();
        ABOUT = Icons.loadImage("about16.gif");
        ABOUT_BIG = Icons.loadImage("about32.gif");
        ADD = Icons.loadImage("AddEc14.gif");
        ADD_MULTI = Icons.loadImage("AddMultiEc14.gif");
        ALIGN_CENTER = Icons.loadImage("alignCenter.gif");
        ALIGN_LEFT = Icons.loadImage("alignLeft.gif");
        ALIGN_RIGHT = Icons.loadImage("alignRight.gif");
        ANCHOR = Icons.loadImage("anchor9.png");
        BOLD = Icons.loadImage("bold.gif");
        CANCEL = Icons.loadImage("CancelEc_16.gif");
        CASCADE = Icons.loadImage("cascadeWindows16.gif");
        CAUTION = Icons.loadImage("CautionEc14.gif");
        CLICK_ACTIONS_OFF = Icons.loadImage("clickActionIconOff.png");
        CLICK_ACTIONS_ON = Icons.loadImage("clickActionIconOn.png");
        CLOSE = Icons.loadImage("FileClosedEc16.gif");
        CLOSED_HAND = Icons.loadImage("ClosedHand32.png");
        CLOCK = Icons.loadImage("clock16.gif");
        CHECK_SM = Icons.loadImage("CheckSmEc14.gif");
        CHECK_SM_TRANS = Icons.loadImage("CheckSmTrans.png");
        CHECK_BASIC = Icons.loadImage("CheckEc14Basic.gif");
        CHECK_FAT = Icons.loadImage("CheckEc15.gif");
        COLUMN = Icons.loadImage("ColumnEc14.gif");
        COLUMN_ADD = Icons.loadImage("ColAddEc16.gif");
        COMMENT = Icons.loadImage("comment16.gif");
        CONN_CFG = Icons.loadImage("ConnsEc16.gif");
        CONNECT = Icons.loadImage("ConnEc16.gif");
        CORNER = Icons.loadImage("corner.gif");
        COPY = Icons.loadImage("copy16.gif");
        CUT = Icons.loadImage("cut16.gif");
        CUSTOM_TYPE = Icons.loadImage("custom_type16.png");
        DATABASE = Icons.loadImage("DbEc16.gif");
        DB_COMPARE_REFRESH = Icons.loadImage("DbCompareRefresh.png");
        DB_EXPL = Icons.loadImage("DbExplEc16.gif");
        DB_DOC = Icons.loadImage("DbDocEc16.gif");
        DELETE = Icons.loadImage("delete16.gif");
        DISCONNECT = Icons.loadImage("UnConnEc16.gif");
        DIAGRAM = Icons.loadImage("relation16.gif");
        ERASE = Icons.loadImage("delete16.gif");
        ERROR = Icons.loadImage("ballRed16.gif");
        EXECUTE = Icons.loadImage("play16.gif");
        EXIT = Icons.loadImage("exit16.gif");
        FOREIGN_KEY = Icons.loadImage("FkEc16.gif");
        FK_GRAY = Icons.loadImage("FkEc16_gray.gif");
        FK_ADD = Icons.loadImage("FkAddEc16.gif");
        FIND = Icons.loadImage("find16.gif");
        FILE_PATH = Icons.loadImage("open16.gif");
        FROM_SERVER = Icons.loadImage("RevEngEc16.gif");
        HELP_CONTENTS = Icons.loadImage("helpContents16.gif");
        ITALIC = Icons.loadImage("italic.gif");
        LOGO = Icons.loadImage("LogoEc18.gif");
        INDEX = Icons.loadImage("IndexEc16b.gif");
        INDEX_GRAY = Icons.loadImage("IndexEc16b_gray.gif");
        MINUS = Icons.loadImage("RemoveEc14.gif");
        MYSQL = Icons.loadImage("mySql16.gif");
        NAVIGATOR = Icons.loadImage("Navigator3.gif");
        NEW = Icons.loadImage("new16.gif");
        NOTE = Icons.loadImage("pin_gb16.png");
        NULL_ICON = Icons.loadImage("transparent16.gif");
        NULLABLE = Icons.loadImage("nullable_16.png");
        NULLABLE_GRAY = Icons.loadImage("nullable_16_gray.png");
        OK = Icons.loadImage("ok12d.gif");
        OPEN = Icons.loadImage("open3.png");
        OPEN_HAND = Icons.loadImage("OpenHand32.gif");
        OPTIONS = Icons.loadImage("options16.gif");
        PASTE = Icons.loadImage("paste16.gif");
        PIN = Icons.loadImage("pin_gb16.png");
        PK = Icons.loadImage("pkb16.gif");
        PK_GRAY = Icons.loadImage("pkb16_gray.png");
        PK1 = Icons.loadImage("pkIcons/pkb1_16.gif");
        PK2 = Icons.loadImage("pkIcons/pkb2_16.gif");
        PK3 = Icons.loadImage("pkIcons/pkb3_16.gif");
        PK4 = Icons.loadImage("pkIcons/pkb4_16.gif");
        PK5 = Icons.loadImage("pkIcons/pkb5_16.gif");
        PK6 = Icons.loadImage("pkIcons/pkb6_16.gif");
        PK7 = Icons.loadImage("pkIcons/pkb7_16.gif");
        PK8 = Icons.loadImage("pkIcons/pkb8_16.gif");
        PK9 = Icons.loadImage("pkIcons/pkb9_16.gif");
        PREFERENCES = Icons.loadImage("PrefEc14.gif");
        PRINT = Icons.loadImage("print.gif");
        PROC = Icons.loadImage("ProcEc16.gif");
        PROPS = Icons.loadImage("PropEc16.gif");
        QUERY = Icons.loadImage("query16.png");
        QUERY_BLDR = Icons.loadImage("query_builder.png");
        QUESTION_DLG = Icons.loadImage("question_dlg16.gif");
        QUESTION = Icons.loadImage("question_16.gif");
        QUESTION_SMALL = Icons.loadImage("Question12.gif");
        REMOVE_GLYPH = Icons.loadImage("RemoveGlyphEc14.gif");
        REPLACE = Icons.loadImage("replace16.gif");
        REDO = Icons.loadImage("redoNb6516.gif");
        REFRESH = Icons.loadImage("refresh16.gif");
        REVERSE = Icons.loadImage("RevEngEc16.gif");
        REV_SYNC = Icons.loadImage("RevSyncEc16.gif");
        SCRIPT = Icons.loadImage("ScriptEc15.gif");
        SAVE = Icons.loadImage("save16.gif");
        SAVE_AS = Icons.loadImage("saveAs16.gif");
        SCHEMA = Icons.loadImage("schema3.gif");
        SCRIPT_CALC = Icons.loadImage("ScriptCalcEc15.gif");
        SEARCH = Icons.loadImage("ZoomSmNb16.gif");
        SERVER = Icons.loadImage("server16.gif");
        SEQUENCE = Icons.loadImage("sequence16.gif");
        SPLASH = Icons.loadImage("logo2007b.png");
        STATUS_BORDER_TOP = Icons.loadImage("statusBar/StatusBorderTop.gif");
        STATUS_BORDER_BTM = Icons.loadImage("statusBar/StatusBorderBottom.gif");
        START = Icons.loadImage("start11.png");
        STEP = Icons.loadImage("StepEc12.gif");
        STOP = Icons.loadImage("stop16.gif");
        SECURITY = Icons.loadImage("security16.gif");
        SUCCESS = Icons.loadImage("ballGreen16.gif");
        SQL_COMM = Icons.loadImage("SqlCommEc16.gif");
        TABLE = Icons.loadImage("TblEc14.gif");
        TABLE_ADD = Icons.loadImage("TblAddEc14.gif");
        TABLE_DATA = Icons.loadImage("TblDataEc16.gif");
        TABLE_DATA_VIEWER = Icons.loadImage("TblDataVwrEc16.gif");
        TEXT = Icons.loadImage("text16.gif");
        TRIGGER = Icons.loadImage("TriggerEc16.gif");
        TO_SERVER = Icons.loadImage("ForEngEc16.gif");
        UNDERLINE = Icons.loadImage("underline16.gif");
        UNCOMMENT = Icons.loadImage("uncomment16.gif");
        UNDO = Icons.loadImage("undoNb6516.gif");
        UNIQUE_CONSTRAINT = Icons.loadImage("uniqueConstraint.png");
        VERT_STRIP = Icons.loadImage("vertStrip.gif");
        VIEW = Icons.loadImage("ViewEc16.gif");
        WARNING = Icons.loadImage("warning16.gif");
        ZONE = Icons.loadImage("zone16.png");
        ZOOM_IN = Icons.loadImage("ZoomInNb16.gif");
        ZOOM_OUT = Icons.loadImage("ZoomOutNb16.gif");
        PKS = new ImageIcon[]{Icons.loadImage("pkIcons/pkb1_16.gif"), Icons.loadImage("pkIcons/pkb2_16.gif"), Icons.loadImage("pkIcons/pkb3_16.gif"), Icons.loadImage("pkIcons/pkb4_16.gif"), Icons.loadImage("pkIcons/pkb5_16.gif"), Icons.loadImage("pkIcons/pkb6_16.gif"), Icons.loadImage("pkIcons/pkb7_16.gif"), Icons.loadImage("pkIcons/pkb8_16.gif"), Icons.loadImage("pkIcons/pkb9_16.gif")};
        SPINNER = new ImageIcon[]{Icons.loadImage("spinnerIcons/spinner_dots0_16.png"), Icons.loadImage("spinnerIcons/spinner_dots1_16.png"), Icons.loadImage("spinnerIcons/spinner_dots2_16.png"), Icons.loadImage("spinnerIcons/spinner_dots3_16.png"), Icons.loadImage("spinnerIcons/spinner_dots4_16.png"), Icons.loadImage("spinnerIcons/spinner_dots5_16.png"), Icons.loadImage("spinnerIcons/spinner_dots6_16.png"), Icons.loadImage("spinnerIcons/spinner_dots7_16.png")};
    }
}

