/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.DataEntryResult;
import com.harrand.coreclasses.dataEntry.IMultipleAddCtrl;
import com.harrand.coreclasses.interfaces.ICloseVerify;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coreclasses.system.OsUtil;
import com.harrand.coregui.dataEntry.IFocusable;
import com.harrand.coregui.display.ISizeStorable;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.OkCancelPanel;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.util.LogUtil;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.Border;

public class EditDialog
extends JDialog
implements ComponentListener {
    private Container contentPane;
    private XpHeaderPanel headerPanel_;
    private final OkCancelPanel okCancelPanel_ = new OkCancelPanel();
    private JPanel mainPanel_;
    private IMultipleAddCtrl multipleAddCtrl_ = null;
    private Rectangle bounds_;
    private Image oldIcon_;
    private boolean okHit_ = false;
    private SwingThemeCtrl themeCtrl_;
    private final CancelAction cancelAction_ = new CancelAction();
    private String dlgTitle_;
    private String headerTitle_;
    private String headerDesc_;

    public EditDialog(Frame parent, boolean modal, DataEditor editor) {
        this(parent, modal, (JPanel)((Object)editor), editor.getPreferredBounds(), editor.getTitle());
    }

    public EditDialog(Frame parent, boolean modal, JPanel mainPanel, Rectangle bounds, String title) {
        this(parent, modal, mainPanel, bounds, title, title, null);
    }

    public EditDialog(Frame parent, boolean modal, JPanel mainPanel, Rectangle theBounds, String dlgTitle, String headerTitle, String headerDesc) {
        super(parent, modal);
        this.mainPanel_ = mainPanel;
        this.bounds_ = theBounds;
        this.dlgTitle_ = dlgTitle;
        this.headerTitle_ = headerTitle;
        this.headerDesc_ = headerDesc;
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.setupGui();
    }

    public void setMultipleAddCtrl(IMultipleAddCtrl multipleAddCtrl) {
        this.multipleAddCtrl_ = multipleAddCtrl;
        if (multipleAddCtrl != null) {
            this.okCancelPanel_.btnAddAnother.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ITestResult result = EditDialog.this.processOkHit();
                    if (result.getPassed()) {
                        EditDialog.this.multipleAddCtrl_.addAndAddAnother();
                    }
                }
            });
        } else {
            LogUtil.logErr("EditDialog.warn: Attempting to set null IMultipleAddCtrl");
        }
        this.okCancelPanel_.setShowAddAnotherBtn(true);
        this.okCancelPanel_.invalidate();
        this.okCancelPanel_.revalidate();
        this.okCancelPanel_.repaint();
    }

    public void setIsAddPanel(boolean isAddPanel) {
        this.okCancelPanel_.setIsAddPanel(isAddPanel);
    }

    private void setupGui() {
        this.initComponents();
        this.setTitle();
        this.setIcon();
        this.locateDialog();
        this.addPanels();
        this.addListeners();
        this.getRootPane().setDefaultButton(this.okCancelPanel_.btnOk);
    }

    private void setTitle() {
        this.headerPanel_ = new XpHeaderPanel(this.headerTitle_, this.headerDesc_);
        this.setTitle(this.dlgTitle_);
    }

    private void setIcon() {
        if (this.mainPanel_ instanceof ITitled) {
            ITitled titled = (ITitled)((Object)this.mainPanel_);
            Frame f = JOptionPane.getFrameForComponent(this);
            this.oldIcon_ = f.getIconImage();
            if (f != null && titled.getIcon() != null) {
                ImageIcon icon = titled.getIcon();
                f.setIconImage(icon.getImage());
            }
        }
    }

    private void locateDialog() {
        GuiHelper.locateDialog(this, this.bounds_);
    }

    private final void addPanels() {
        this.contentPane = this.getContentPane();
        this.contentPane.setLayout(new BorderLayout(4, 4));
        this.themeCtrl_.process(this.contentPane);
        Border marginBorder = BorderFactory.createEmptyBorder(10, 20, 10, 20);
        this.mainPanel_.setBorder(marginBorder);
        if (!OsUtil.isWindowsOs()) {
            this.contentPane.add("North", this.headerPanel_);
        }
        this.contentPane.add("Center", this.mainPanel_);
        this.contentPane.add("South", this.okCancelPanel_);
        this.okCancelPanel_.setName("okCancelPanel");
        this.headerPanel_.setName("headerPanel");
    }

    private final void addListeners() {
        this.addOkCancelListeners();
        this.setKeyStrokeMap();
        this.addComponentListener(this);
    }

    private final void setKeyStrokeMap() {
        KeyStroke escapeKeyStroke = KeyStroke.getKeyStroke(27, 0, false);
        this.getRootPane().getInputMap(2).put(escapeKeyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", this.cancelAction_);
    }

    private final void addOkCancelListeners() {
        this.okCancelPanel_.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ITestResult result = EditDialog.this.processOkHit();
                EditDialog.this.okHit_ = result.getPassed();
                if (result.getPassed()) {
                    EditDialog.this.disposeDisp();
                }
            }
        });
        this.okCancelPanel_.btnCancel.addActionListener(this.cancelAction_);
    }

    private ITestResult processOkHit() {
        DataEditor editor;
        ITestResult result = new DataEntryResult(true);
        if (this.mainPanel_ instanceof DataEditor && !(result = (editor = (DataEditor)((Object)this.mainPanel_)).validateData()).getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, result.getSummary(), result.getDetail());
        }
        return result;
    }

    private void disposeDisp() {
        Container parent;
        if (this.oldIcon_ != null && (parent = this.getParent()) instanceof Frame) {
            ((Frame)parent).setIconImage(this.oldIcon_);
        }
        if (this.mainPanel_ instanceof ISizeStorable) {
            ((ISizeStorable)((Object)this.mainPanel_)).setSize(this.getSize());
        }
        this.dispose();
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
        if (this.mainPanel_ instanceof IFocusable) {
            ((IFocusable)((Object)this.mainPanel_)).transferFocus();
        }
    }

    public JPanel getMainEditPanel() {
        return this.mainPanel_;
    }

    public boolean getOkHit() {
        return this.okHit_;
    }

    private void initComponents() {
        this.getContentPane().setLayout(null);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EditDialog.this.closeDialog(evt);
            }
        });
        this.pack();
    }

    private void closeDialog(WindowEvent evt) {
        boolean allowClose = true;
        if (this.mainPanel_ instanceof ICloseVerify) {
            allowClose = ((ICloseVerify)((Object)this.mainPanel_)).allowClose();
        }
        if (allowClose) {
            this.setVisible(false);
            this.disposeDisp();
        }
    }

    public static void main(String[] args) {
        System.out.println("Shouldn't really run this on it's own!!!!");
    }

    class CancelAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            EditDialog.this.okHit_ = false;
            EditDialog.this.disposeDisp();
        }
    }
}

