/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.coregui;

import com.harrand.coreclasses.dataEntry.DataEditor;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.IDotNotable;
import com.harrand.coreclasses.interfaces.IErgonomicPanel;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.list.ISelectedProvider;
import com.harrand.coregui.command.Command;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.command.GroupCommand;
import com.harrand.coregui.command.idf.ISpecificIdfRemoveCmd;
import com.harrand.coregui.command.prompt.PromptCollectionAdd;
import com.harrand.coregui.command.prompt.PromptCollectionRemove;
import com.harrand.coregui.command.prompt.PromptCollectionRemoveMany;
import com.harrand.coregui.dataEntry.IEditorActionFactory;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.panel.AddRemovePanel;
import com.harrand.coregui.panel.HeaderPanel;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.coregui.table.TablePanel;
import com.harrand.util.FileHelper;
import com.harrand.util.LogUtil;
import com.harrand.util.Validator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public final class AddRemoveContainer
extends JPanel
implements ISized,
IErgonomicPanel {
    private JPanel selectablePanel_;
    private final Frame parentFrame_ = ParentFrameSvr.instance().getParentFrame();
    private ISpecificIdfRemoveCmd specificIdfRemoveCmd_ = null;
    private IEditorActionFactory editorActionFactory_;
    private String className_;
    private AddRemovePanel addRemovePanel_;
    private HeaderPanel header_ = null;
    private int headerLevel_;
    private String descText_ = null;
    private String title_;
    private String displayNm_;
    private boolean showHeader_ = true;
    private SwingThemeCtrl themeCtrl_;
    private CommandChain cmdChain_ = null;
    private Rectangle prefBounds_ = new Rectangle(500, 50, 550, 200);
    private String additionalButtonText;
    private ActionListener additionalButtonListener;

    public AddRemoveContainer(JPanel selectablePanel) throws IllegalArgumentException {
        this.initPanel(selectablePanel, 1);
    }

    public AddRemoveContainer(JPanel selectablePanel, boolean showHeader) throws IllegalArgumentException {
        this.showHeader_ = showHeader;
        this.initPanel(selectablePanel, 1);
    }

    public AddRemoveContainer(JPanel selectablePanel, boolean showHeader, String additionalButtonText, ActionListener additionalButtonListener) throws IllegalArgumentException {
        this.showHeader_ = showHeader;
        this.additionalButtonText = additionalButtonText;
        this.additionalButtonListener = additionalButtonListener;
        this.initPanel(selectablePanel, 1);
    }

    public AddRemoveContainer(JPanel selectablePanel, String descText) {
        this.descText_ = descText;
        this.initPanel(selectablePanel, 1);
    }

    public AddRemoveContainer(JPanel selectablePanel, int headerLevel) throws IllegalArgumentException {
        this.initPanel(selectablePanel, headerLevel);
    }

    public void setEditorActionFactory(IEditorActionFactory actionFactory) {
        this.editorActionFactory_ = actionFactory;
        if (this.selectablePanel_ instanceof TablePanel) {
            ((TablePanel)this.selectablePanel_).setEditorActionFactory(this.editorActionFactory_);
        }
    }

    private void initPanel(JPanel selectablePanel, int headerLevel) throws IllegalArgumentException {
        this.selectablePanel_ = selectablePanel;
        this.checkPanelSelectable();
        ISelectedProvider selectable = (ISelectedProvider)((Object)this.selectablePanel_);
        this.className_ = selectable.getIdfClassName();
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.title_ = selectable.getDisplayPlural();
        this.displayNm_ = selectable.getDisplayName();
        this.headerLevel_ = headerLevel;
        this.cmdChain_ = CommandChainMgr.getInstance().getCommandChain();
        this.initComponents();
        this.initAddRemovePanel();
        this.addPanels();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void initAddRemovePanel() {
        if (this.additionalButtonText != null) {
            String buttonAppendText = "";
            this.addRemovePanel_ = new AddRemovePanel(buttonAppendText, this.additionalButtonText);
        } else {
            this.addRemovePanel_ = new AddRemovePanel();
        }
    }

    public void setNames() {
        this.setName("addRemoveContainer");
    }

    public void setHeaderTitle(String title) {
        this.title_ = title;
        if (this.header_ != null) {
            this.header_.setTitle(this.title_);
        }
    }

    public void setPreferredBounds(Rectangle prefBounds) {
        this.prefBounds_ = prefBounds;
    }

    public void setSpecificIdfRemoveCmd(ISpecificIdfRemoveCmd specificCmd) {
        if (specificCmd instanceof Command) {
            this.specificIdfRemoveCmd_ = specificCmd;
        } else if (specificCmd != null) {
            LogUtil.logErr("AddRemoveContainer.err: specificCmd not instance of Command.");
        }
    }

    public ISpecificIdfRemoveCmd getSpecificIdfRemoveCmd() {
        return this.specificIdfRemoveCmd_;
    }

    private Collector getCollector() {
        return ((ISelectedProvider)((Object)this.selectablePanel_)).getCollector();
    }

    private void checkPanelSelectable() throws IllegalArgumentException {
        if (!(this.selectablePanel_ instanceof ISelectedProvider)) {
            throw new IllegalArgumentException("SelectablePanel must be an instance of ISelectable.");
        }
    }

    private void addPanels() {
        this.setLayout(new BorderLayout());
        if (this.showHeader_) {
            this.add((Component)this.getHeaderPanel(), "North");
        }
        this.add((Component)this.getBodyPanel(), "Center");
    }

    private JPanel getBodyPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.addRemovePanel_, "East");
        panel.add((Component)this.selectablePanel_, "Center");
        this.addRemovePanel_.setBorder(GuiHelper.getEmptyBorder());
        this.selectablePanel_.setBorder(GuiHelper.getEmptyBorder());
        this.selectablePanel_.setName("jTablePanel");
        this.addRemovePanel_.setName("addRemovePanel");
        if (this.hasXpHeader()) {
            GuiHelper.addBodyPanelBorder(panel);
        }
        return panel;
    }

    private JPanel getHeaderPanel() {
        JPanel panel;
        if (!this.hasXpHeader()) {
            panel = new HeaderPanel(this.title_, this.headerLevel_, false);
            this.header_ = (HeaderPanel)panel;
        } else {
            panel = new XpHeaderPanel(this.title_, this.descText_);
        }
        return panel;
    }

    private boolean hasXpHeader() {
        return Validator.isStringValid(this.descText_);
    }

    private void setCosmetics() {
        this.themeCtrl_.process(this);
        this.addRemovePanel_.setToolTipName(this.displayNm_);
    }

    private void addListeners() {
        this.addAddRemoveListeners();
    }

    private void addAddRemoveListeners() {
        this.addRemovePanel_.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddRemoveContainer.this.showEditDialog();
            }
        });
        this.addRemovePanel_.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddRemoveContainer.this.removeSelected();
            }
        });
        if (this.addRemovePanel_.btnAdditional != null) {
            this.setAdditionalButtonListener(this.additionalButtonListener);
        }
    }

    public void setAdditionalButtonListener(ActionListener listener) {
        this.additionalButtonListener = listener;
        this.addRemovePanel_.setAdditionalButtonListener(this.additionalButtonListener);
    }

    private void removeSelected() {
        List removeIdfs = ((ISelectedProvider)((Object)this.selectablePanel_)).getSelectedIds();
        int count = removeIdfs.size();
        if (count == 0) {
            GuiMessageHelper.showInputErrMsg(null, FileHelper.getRes("err.title.invalid.selection"), FileHelper.getRes("err.msg.table.row.not.selected"));
        } else if (count == 1) {
            this.removeSingle((String)removeIdfs.get(0));
        } else if (count > 1) {
            this.removeManyDisp(removeIdfs);
        }
    }

    private void removeSingle(String idfName) {
        if (this.cmdChain_ == null) {
            LogUtil.logMsg("AddRemContainer cmdChain NULL");
        }
        Command cmd = null;
        if (this.getSpecificIdfRemoveCmd() != null) {
            Command cmdBase = (Command)((Object)this.getSpecificIdfRemoveCmd());
            Collector coll = this.getCollector();
            Identifiable idf = coll.get(this.className_, idfName);
            ((ISpecificIdfRemoveCmd)((Object)cmdBase)).setIdfDotNote(this.getIdfDotNoteOrNm(idf));
            cmd = cmdBase.duplicate();
            cmd.setCommandChain(this.cmdChain_);
        } else {
            cmd = new PromptCollectionRemove(this.getCollector(), this.className_, idfName);
        }
        cmd.actionPerformed(new ActionEvent(this, 0, ""));
    }

    private void removeManyDisp(List idfNames) {
        if (this.getSpecificIdfRemoveCmd() != null) {
            this.removeManySpecific(idfNames);
        } else {
            this.removeManyGeneric(idfNames);
        }
    }

    private void removeManySpecific(List idfNames) {
        boolean yesHit = GuiMessageHelper.showYesNoMsg(null, "Confirm - Remove", "Are you sure you want to remove the selected items?");
        if (!yesHit) {
            return;
        }
        Collector coll = this.getCollector();
        Command baseCmd = (Command)((Object)this.getSpecificIdfRemoveCmd());
        ArrayList<Command> subCmds = new ArrayList<Command>();
        for (String idfName : idfNames) {
            Identifiable idf = coll.get(this.className_, idfName);
            ISpecificIdfRemoveCmd cmdSpecific = (ISpecificIdfRemoveCmd)((Object)baseCmd);
            cmdSpecific.setIdfDotNote(this.getIdfDotNoteOrNm(idf));
            cmdSpecific.setShowWarning(false);
            Command cmdDup = ((Command)((Object)cmdSpecific)).duplicate();
            subCmds.add(cmdDup);
        }
        String pluralNm = this.getCollector().getDisplayPlural(this.className_);
        GroupCommand groupCmd = new GroupCommand(subCmds, "Remove Many " + pluralNm);
        groupCmd.setCommandChain(this.cmdChain_);
        groupCmd.actionPerformed(new ActionEvent(this, 0, ""));
    }

    private void removeManyGeneric(List idfNames) {
        ArrayList<Identifiable> idfs = new ArrayList<Identifiable>();
        for (String name : idfNames) {
            idfs.add(this.getCollector().get(this.className_, name));
        }
        if (this.cmdChain_ == null) {
            LogUtil.logMsg("AddRemContainer cmdChain NULL");
        }
        PromptCollectionRemoveMany cmd = new PromptCollectionRemoveMany(this.getCollector(), this.className_, idfs);
        cmd.setCommandChain(this.cmdChain_);
        cmd.actionPerformed(new ActionEvent(this, 0, ""));
    }

    private String getIdfDotNoteOrNm(Identifiable idf) {
        if (idf instanceof IDotNotable) {
            return ((IDotNotable)((Object)idf)).getDotNote();
        }
        return idf.getName();
    }

    private void showEditDialog() {
        ImageIcon oldIcon = this.parentFrame_ != null ? new ImageIcon(this.parentFrame_.getIconImage()) : null;
        ActionListener editorAction = null;
        if (this.editorActionFactory_ != null) {
            editorAction = this.editorActionFactory_.getAddEditorAction(this.getCollector(), this.className_);
        }
        if (editorAction != null) {
            editorAction.actionPerformed(null);
        } else {
            DataEditor editor = this.getDataEditor();
            PromptCollectionAdd cmd = new PromptCollectionAdd(this.getCollector(), this.className_, editor);
            cmd.setCommandChain(this.cmdChain_);
            cmd.actionPerformed(new ActionEvent(this, 0, ""));
        }
        if (this.parentFrame_ != null && oldIcon != null) {
            this.parentFrame_.setIconImage(oldIcon.getImage());
        }
    }

    private DataEditor getDataEditor() {
        DataEditor editor = null;
        editor = ((ISelectedProvider)((Object)this.selectablePanel_)).getDataEditor(null);
        return editor;
    }

    @Override
    public Rectangle getPreferredBounds() {
        return this.prefBounds_;
    }

    private void initComponents() {
        this.setLayout(null);
    }

    @Override
    public JButton getDefaultButton() {
        if (this.selectablePanel_ instanceof IErgonomicPanel) {
            return ((IErgonomicPanel)((Object)this.selectablePanel_)).getDefaultButton();
        }
        return null;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.selectablePanel_ instanceof IErgonomicPanel) {
            return ((IErgonomicPanel)((Object)this.selectablePanel_)).getIcon();
        }
        return null;
    }

    @Override
    public String getTitle() {
        if (this.selectablePanel_ instanceof IErgonomicPanel) {
            return ((IErgonomicPanel)((Object)this.selectablePanel_)).getTitle();
        }
        return "";
    }

    @Override
    public String getToolTip() {
        if (this.selectablePanel_ instanceof IErgonomicPanel) {
            return ((IErgonomicPanel)((Object)this.selectablePanel_)).getToolTip();
        }
        return "";
    }
}

